/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.websocket;

import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.SocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.websocket.DefaultWebSocketFrame;
import org.json.JSONException;
import org.json.JSONObject;

public class MockChannel
implements Channel {
    private StringWriter writer = new StringWriter();

    public ChannelConfig getConfig() {
        return null;
    }

    public SocketAddress getLocalAddress() {
        return null;
    }

    public SocketAddress getRemoteAddress() {
        return null;
    }

    public boolean isBound() {
        return true;
    }

    public boolean isConnected() {
        return false;
    }

    public ChannelFuture write(Object message) {
        if (!(message instanceof DefaultWebSocketFrame)) {
            throw new IllegalStateException("Expected a DefaultWebSocketFrame.");
        }
        this.writer.write(((DefaultWebSocketFrame)message).getTextData());
        return null;
    }

    public JSONObject getJSONPayload() {
        if (this.writer.getBuffer().length() == 0) {
            return null;
        }
        return this.getJSONPayload(0L);
    }

    public JSONObject getJSONPayload(long waitTimeout) {
        long start = System.currentTimeMillis();
        while (this.writer.getBuffer().length() == 0) {
            if (System.currentTimeMillis() <= start + waitTimeout) continue;
            throw new RuntimeException("Timed out waiting for data to be pushed onto the channel.");
        }
        try {
            JSONObject jSONObject = new JSONObject(this.writer.toString());
            return jSONObject;
        }
        catch (JSONException e) {
            throw new RuntimeException("Invalid JSON payload [" + this.writer.toString() + "].", e);
        }
        finally {
            this.clear();
        }
    }

    public void clear() {
        this.writer.getBuffer().setLength(0);
    }

    public ChannelFuture bind(SocketAddress arg0) {
        return null;
    }

    public ChannelFuture close() {
        return null;
    }

    public ChannelFuture connect(SocketAddress arg0) {
        return null;
    }

    public ChannelFuture disconnect() {
        return null;
    }

    public ChannelFuture getCloseFuture() {
        return (ChannelFuture)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ChannelFuture.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
    }

    public ChannelFactory getFactory() {
        return null;
    }

    public Integer getId() {
        return null;
    }

    public int getInterestOps() {
        return 0;
    }

    public Channel getParent() {
        return null;
    }

    public ChannelPipeline getPipeline() {
        return null;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReadable() {
        return false;
    }

    public boolean isWritable() {
        return false;
    }

    public ChannelFuture setInterestOps(int arg0) {
        return null;
    }

    public ChannelFuture setReadable(boolean arg0) {
        return null;
    }

    public ChannelFuture unbind() {
        return null;
    }

    public ChannelFuture write(Object arg0, SocketAddress arg1) {
        return null;
    }

    public int compareTo(Channel o) {
        return 0;
    }
}

