/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket;

import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.server.websocket.OpHandler;
import org.infinispan.server.websocket.WebSocketServer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.jboss.netty.util.CharsetUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class WebSocketServerHandler
extends SimpleChannelUpstreamHandler {
    private static final String INFINISPAN_WS_JS_FILENAME = "infinispan-ws.js";
    private CacheContainer cacheContainer;
    private Map<String, OpHandler> operationHandlers;
    private boolean connectionUpgraded;
    private Map<String, Cache> startedCaches;
    private WebSocketServerHandshaker handshaker;

    public WebSocketServerHandler(CacheContainer cacheContainer, Map<String, OpHandler> operationHandlers, Map<String, Cache> startedCaches) {
        this.cacheContainer = cacheContainer;
        this.operationHandlers = operationHandlers;
        this.startedCaches = startedCaches;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof HttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        if (req.getMethod() != HttpMethod.GET) {
            this.sendHttpResponse(ctx, req, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        if (!this.connectionUpgraded && req.getUri().equalsIgnoreCase("/infinispan-ws.js")) {
            DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            this.loadScriptToResponse(req, res);
            this.sendHttpResponse(ctx, req, (HttpResponse)res);
            return;
        }
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(req), null, false);
        this.handshaker = wsFactory.newHandshaker(req);
        if (this.handshaker == null) {
            wsFactory.sendUnsupportedWebSocketVersionResponse(ctx.getChannel());
        } else {
            this.handshaker.handshake(ctx.getChannel(), req).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        Channels.fireExceptionCaught((Channel)future.getChannel(), (Throwable)future.getCause());
                    } else {
                        WebSocketServerHandler.this.connectionUpgraded = true;
                    }
                }
            });
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof PingWebSocketFrame) {
            ctx.getChannel().write((Object)new PongWebSocketFrame(frame.getBinaryData()));
        } else if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.getChannel(), (CloseWebSocketFrame)frame);
        } else {
            try {
                ChannelBuffer binaryData = frame.getBinaryData();
                if (binaryData == null) {
                    return;
                }
                JSONObject payload = new JSONObject(binaryData.toString(CharsetUtil.UTF_8));
                String opCode = (String)payload.get("opCode");
                String cacheName = (String)payload.opt("cacheName");
                Cache<Object, Object> cache = this.getCache(cacheName);
                OpHandler handler = this.operationHandlers.get(opCode);
                if (handler != null) {
                    handler.handleOp(payload, cache, ctx);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<Object, Object> getCache(String cacheName) {
        Cache cache;
        String key = cacheName;
        if (key == null) {
            key = "";
        }
        if ((cache = this.startedCaches.get(key)) == null) {
            Map<String, Cache> map = this.startedCaches;
            synchronized (map) {
                cache = this.startedCaches.get(key);
                if (cache == null) {
                    cache = cacheName != null ? this.cacheContainer.getCache(key) : this.cacheContainer.getCache();
                    this.startedCaches.put(key, cache);
                    cache.start();
                }
            }
        }
        return cache;
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        if (res.getStatus().getCode() != 200) {
            res.setContent(ChannelBuffers.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
        }
        ChannelFuture f = ctx.getChannel().write((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().getCode() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private void loadScriptToResponse(HttpRequest req, DefaultHttpResponse res) {
        String wsAddress = this.getWebSocketLocation(req);
        StringWriter writer = new StringWriter();
        writer.write("var defaultWSAddress = '" + wsAddress + "';");
        writer.write(WebSocketServer.getJavascript());
        ChannelBuffer content = ChannelBuffers.copiedBuffer((CharSequence)writer.toString(), (Charset)CharsetUtil.UTF_8);
        res.setHeader("Content-Type", (Object)"text/javascript; charset=UTF-8");
        HttpHeaders.setContentLength((HttpMessage)res, (long)content.readableBytes());
        res.setContent(content);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        e.getCause().printStackTrace();
        e.getChannel().close();
    }

    private String getWebSocketLocation(HttpRequest req) {
        return "ws://" + req.getHeader("Host") + "/";
    }
}

