/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket.handlers;

import org.infinispan.server.websocket.handlers.MockClient;
import org.infinispan.websocket.MockChannel;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="websocket.handlers.OpHandlerTest", groups={"unit"})
public class OpHandlerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws JSONException {
        MockChannel mockChannel = new MockChannel();
        MockClient firstCacheClient = new MockClient("firstCache", mockChannel);
        try {
            firstCacheClient.put("a", "aVal");
            firstCacheClient.put("b", "bVal");
            firstCacheClient.get("a");
            JSONObject jsonPayload = mockChannel.getJSONPayload();
            Assert.assertEquals((Object)"firstCache", (Object)jsonPayload.get("cacheName"));
            Assert.assertEquals((Object)"a", (Object)jsonPayload.get("key"));
            Assert.assertEquals((Object)"aVal", (Object)jsonPayload.get("value"));
            Assert.assertEquals((Object)"text/plain", (Object)jsonPayload.get("mime"));
            firstCacheClient.get("b");
            jsonPayload = mockChannel.getJSONPayload();
            Assert.assertEquals((Object)"firstCache", (Object)jsonPayload.get("cacheName"));
            Assert.assertEquals((Object)"b", (Object)jsonPayload.get("key"));
            Assert.assertEquals((Object)"bVal", (Object)jsonPayload.get("value"));
            Assert.assertEquals((Object)"text/plain", (Object)jsonPayload.get("mime"));
            firstCacheClient.get("x");
            jsonPayload = mockChannel.getJSONPayload();
            Assert.assertEquals((Object)"firstCache", (Object)jsonPayload.get("cacheName"));
            Assert.assertEquals((Object)"x", (Object)jsonPayload.get("key"));
            Assert.assertEquals(null, (Object)jsonPayload.get("value"));
            firstCacheClient.notify("a");
            jsonPayload = mockChannel.getJSONPayload(1000L);
            Assert.assertEquals((Object)"aVal", (Object)jsonPayload.get("value"));
            firstCacheClient.getCache().put((Object)"a", (Object)"aNewValue");
            jsonPayload = mockChannel.getJSONPayload();
            Assert.assertEquals((Object)"aNewValue", (Object)jsonPayload.get("value"));
            firstCacheClient.getCache().put((Object)"b", (Object)"bNewValue");
            try {
                mockChannel.getJSONPayload(500L);
                Assert.fail((String)"Expected timeout");
            }
            catch (RuntimeException e) {
                Assert.assertEquals((String)"Timed out waiting for data to be pushed onto the channel.", (String)e.getMessage());
            }
            firstCacheClient.remove("a");
            firstCacheClient.get("a");
            jsonPayload = mockChannel.getJSONPayload();
            Assert.assertEquals((Object)"firstCache", (Object)jsonPayload.get("cacheName"));
            Assert.assertEquals((Object)"a", (Object)jsonPayload.get("key"));
            Assert.assertEquals(null, (Object)jsonPayload.get("value"));
        }
        finally {
            firstCacheClient.stop();
        }
    }
}

