/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.infinispan.Cache;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelUtils {
    public static void pushCacheValue(String key, Cache<Object, Object> cache, ChannelHandlerContext ctx) throws JSONException {
        Object value = cache.get((Object)key);
        JSONObject responseObject = ChannelUtils.toJSON(key, value, cache.getName());
        ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(responseObject.toString()));
    }

    public static JSONObject toJSON(String key, Object value, String cacheName) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("cacheName", (Object)cacheName);
        jsonObject.put("key", (Object)key);
        if (value != null) {
            JSONObject valueObject = new JSONObject(value);
            if (valueObject.get("bytes") == null) {
                jsonObject.put("value", (Object)valueObject.toString());
                jsonObject.put("mime", (Object)"application/json");
            } else {
                jsonObject.put("value", value);
                jsonObject.put("mime", (Object)"text/plain");
            }
        } else {
            jsonObject.put("value", JSONObject.NULL);
        }
        return jsonObject;
    }
}

