/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket.handlers;

import io.netty.channel.ChannelHandlerContext;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.server.websocket.OpHandler;
import org.infinispan.server.websocket.handlers.GetHandler;
import org.infinispan.server.websocket.handlers.NotifyHandler;
import org.infinispan.server.websocket.handlers.PutHandler;
import org.infinispan.server.websocket.handlers.RemoveHandler;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.websocket.MockChannel;
import org.infinispan.websocket.MockChannelHandlerContext;
import org.json.JSONException;
import org.json.JSONObject;

public class MockClient {
    private String cacheName;
    private CacheContainer cacheContainer;
    private Cache<Object, Object> cache;
    private OpHandler putHandler = new PutHandler();
    private OpHandler getHandler = new GetHandler();
    private OpHandler removeHandler = new RemoveHandler();
    private OpHandler notifyHandler = new NotifyHandler();
    private MockChannelHandlerContext ctx;

    public MockClient(String cacheName, MockChannel mockChannel) {
        this.cacheName = cacheName;
        this.ctx = new MockChannelHandlerContext(mockChannel);
        this.cacheContainer = TestCacheManagerFactory.createCacheManager();
        this.cache = this.cacheContainer.getCache(cacheName);
    }

    public void put(String key, String value) {
        this.callHandler(this.putHandler, this.toPut(key, value, "text/plain"));
    }

    public void put(String key, JSONObject value) {
        this.callHandler(this.putHandler, this.toPut(key, value.toString(), "application/json"));
    }

    public void get(String key) {
        this.callHandler(this.getHandler, this.toGet(key));
    }

    public void remove(String key) {
        this.callHandler(this.removeHandler, this.toRemove(key));
    }

    public void notify(String key) {
        this.callHandler(this.notifyHandler, this.toNotify(key));
    }

    public void unnotify(String key) {
        this.callHandler(this.notifyHandler, this.toUnnotify(key));
    }

    public Cache<Object, Object> getCache() {
        return this.cache;
    }

    private void callHandler(OpHandler handler, JSONObject jsonObj) {
        try {
            handler.handleOp(jsonObj, this.cache, (ChannelHandlerContext)this.ctx);
        }
        catch (JSONException e) {
            throw new RuntimeException("JSON Exception", e);
        }
    }

    private JSONObject toPut(String key, String value, String mimeType) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("opCode", (Object)"put");
            jsonObj.put("cacheName", (Object)this.cacheName);
            jsonObj.put("key", (Object)key);
            jsonObj.put("value", (Object)value);
            jsonObj.put("mime", (Object)mimeType);
        }
        catch (JSONException e) {
            throw new RuntimeException("JSON Exception", e);
        }
        return jsonObj;
    }

    private JSONObject toGet(String key) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("opCode", (Object)"get");
            jsonObj.put("cacheName", (Object)this.cacheName);
            jsonObj.put("key", (Object)key);
        }
        catch (JSONException e) {
            throw new RuntimeException("JSON Exception", e);
        }
        return jsonObj;
    }

    private JSONObject toRemove(String key) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("opCode", (Object)"remove");
            jsonObj.put("cacheName", (Object)this.cacheName);
            jsonObj.put("key", (Object)key);
        }
        catch (JSONException e) {
            throw new RuntimeException("JSON Exception", e);
        }
        return jsonObj;
    }

    private JSONObject toNotify(String key) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("opCode", (Object)"notify");
            jsonObj.put("cacheName", (Object)this.cacheName);
            jsonObj.put("key", (Object)key);
        }
        catch (JSONException e) {
            throw new RuntimeException("JSON Exception", e);
        }
        return jsonObj;
    }

    private JSONObject toUnnotify(String key) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("opCode", (Object)"unnotify");
            jsonObj.put("cacheName", (Object)this.cacheName);
            jsonObj.put("key", (Object)key);
        }
        catch (JSONException e) {
            throw new RuntimeException("JSON Exception", e);
        }
        return jsonObj;
    }

    public void stop() {
        this.cacheContainer.stop();
    }
}

