/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.websocket;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.SocketAddress;
import org.json.JSONException;
import org.json.JSONObject;

public class MockChannel
implements Channel {
    private StringWriter writer = new StringWriter();

    public ChannelFuture write(Object message) {
        if (!(message instanceof TextWebSocketFrame)) {
            throw new IllegalStateException("Expected a TextWebSocketFrame but got " + message);
        }
        this.writer.write(((TextWebSocketFrame)message).text());
        return null;
    }

    public JSONObject getJSONPayload() {
        if (this.writer.getBuffer().length() == 0) {
            return null;
        }
        return this.getJSONPayload(0L);
    }

    public JSONObject getJSONPayload(long waitTimeout) {
        long start = System.currentTimeMillis();
        while (this.writer.getBuffer().length() == 0) {
            if (System.currentTimeMillis() <= start + waitTimeout) continue;
            throw new RuntimeException("Timed out waiting for data to be pushed onto the channel.");
        }
        try {
            JSONObject jSONObject = new JSONObject(this.writer.toString());
            return jSONObject;
        }
        catch (JSONException e) {
            throw new RuntimeException("Invalid JSON payload [" + this.writer.toString() + "].", e);
        }
        finally {
            this.clear();
        }
    }

    public void clear() {
        this.writer.getBuffer().setLength(0);
    }

    public ChannelFuture closeFuture() {
        return (ChannelFuture)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ChannelFuture.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
    }

    public EventLoop eventLoop() {
        return null;
    }

    public Channel parent() {
        return null;
    }

    public ChannelConfig config() {
        return null;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isRegistered() {
        return false;
    }

    public boolean isActive() {
        return false;
    }

    public ChannelMetadata metadata() {
        return null;
    }

    public SocketAddress localAddress() {
        return null;
    }

    public SocketAddress remoteAddress() {
        return null;
    }

    public boolean isWritable() {
        return false;
    }

    public Channel.Unsafe unsafe() {
        return null;
    }

    public ChannelPipeline pipeline() {
        return null;
    }

    public ByteBufAllocator alloc() {
        return null;
    }

    public ChannelPromise newPromise() {
        return null;
    }

    public ChannelProgressivePromise newProgressivePromise() {
        return null;
    }

    public ChannelFuture newSucceededFuture() {
        return null;
    }

    public ChannelFuture newFailedFuture(Throwable cause) {
        return null;
    }

    public ChannelPromise voidPromise() {
        return null;
    }

    public ChannelFuture bind(SocketAddress localAddress) {
        return null;
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        return null;
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return null;
    }

    public ChannelFuture disconnect() {
        return null;
    }

    public ChannelFuture close() {
        return null;
    }

    public ChannelFuture deregister() {
        return null;
    }

    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return null;
    }

    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return null;
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        return null;
    }

    public ChannelFuture disconnect(ChannelPromise promise) {
        return null;
    }

    public ChannelFuture close(ChannelPromise promise) {
        return null;
    }

    public ChannelFuture deregister(ChannelPromise promise) {
        return null;
    }

    public Channel read() {
        return null;
    }

    public ChannelFuture write(Object msg, ChannelPromise promise) {
        this.write(msg);
        return promise.setSuccess();
    }

    public Channel flush() {
        return null;
    }

    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        this.write(msg);
        return promise.setSuccess();
    }

    public ChannelFuture writeAndFlush(Object msg) {
        this.write(msg);
        return null;
    }

    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return null;
    }

    public int compareTo(Channel o) {
        return 0;
    }
}

