/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket.handlers;

import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.server.websocket.CacheListener;
import org.infinispan.server.websocket.ChannelUtils;
import org.infinispan.server.websocket.OpHandler;
import org.infinispan.server.websocket.json.JsonObject;

public class NotifyHandler
implements OpHandler {
    private Map<Cache, CacheListener> listeners = CollectionFactory.makeConcurrentMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleOp(JsonObject opPayload, Cache<Object, Object> cache, ChannelHandlerContext ctx) {
        String[] keyTokens;
        String opCode = (String)opPayload.get("opCode");
        String key = (String)opPayload.get("key");
        String[] onEvents = (String[])opPayload.get("onEvents");
        CacheListener listener = this.listeners.get(cache);
        if (key == null) {
            key = "*";
        }
        if (listener == null) {
            NotifyHandler notifyHandler = this;
            synchronized (notifyHandler) {
                listener = this.listeners.get(cache);
                if (listener == null) {
                    listener = new CacheListener();
                    this.listeners.put(cache, listener);
                    cache.addListener((Object)listener);
                }
            }
        }
        for (String keyToken : keyTokens = key.split(",")) {
            CacheListener.ChannelNotifyParams notifyParams = new CacheListener.ChannelNotifyParams(ctx.channel(), keyToken, onEvents);
            if (opCode.equals("notify")) {
                listener.addChannel(notifyParams);
                if (keyToken.equals("*")) continue;
                ChannelUtils.pushCacheValue(keyToken, cache, ctx);
                continue;
            }
            if (!opCode.equals("unnotify")) continue;
            listener.removeChannel(notifyParams);
        }
    }
}

