/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.server.websocket.ChannelUtils;
import org.infinispan.server.websocket.json.JsonObject;
import org.infinispan.server.websocket.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener
public class CacheListener {
    private static final Log logger = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private List<ChannelNotifyParams> channels = new CopyOnWriteArrayList<ChannelNotifyParams>();

    @CacheEntryCreated
    public void cacheEntryCreated(CacheEntryCreatedEvent<Object, Object> event) {
        this.notifyChannels((CacheEntryEvent<Object, Object>)event, event.getType());
    }

    @CacheEntryModified
    public void cacheEntryModified(CacheEntryModifiedEvent<Object, Object> event) {
        this.notifyChannels((CacheEntryEvent<Object, Object>)event, event.getType());
    }

    @CacheEntryRemoved
    public void cacheEntryRemoved(CacheEntryRemovedEvent<Object, Object> event) {
        this.notifyChannels((CacheEntryEvent<Object, Object>)event, event.getType());
    }

    private void notifyChannels(CacheEntryEvent<Object, Object> event, Event.Type eventType) {
        JsonObject jsonObject;
        if (event.isPre()) {
            return;
        }
        Cache cache = event.getCache();
        Object key = event.getKey();
        switch (eventType) {
            case CACHE_ENTRY_CREATED: {
                Object value = cache.get(key);
                jsonObject = ChannelUtils.toJSON(key.toString(), value, cache.getName());
                break;
            }
            case CACHE_ENTRY_MODIFIED: {
                Object value = event.getValue();
                jsonObject = ChannelUtils.toJSON(key.toString(), value, cache.getName());
                break;
            }
            case CACHE_ENTRY_REMOVED: {
                jsonObject = ChannelUtils.toJSON(key.toString(), null, cache.getName());
                break;
            }
            default: {
                return;
            }
        }
        jsonObject.put("eventType", (Object)eventType.toString());
        String jsonString = jsonObject.toString();
        for (ChannelNotifyParams channel : this.channels) {
            if (!channel.channel.isOpen() || !channel.onEvents.contains(eventType)) continue;
            if (channel.key != null) {
                if (!event.getKey().equals(channel.key) && !channel.key.equals("*")) continue;
                channel.channel.writeAndFlush((Object)new TextWebSocketFrame(jsonString));
                continue;
            }
            channel.channel.writeAndFlush((Object)new TextWebSocketFrame(jsonString));
        }
    }

    public void addChannel(ChannelNotifyParams channel) {
        if (!this.channels.contains(channel)) {
            this.channels.add(channel);
            channel.channel.closeFuture().addListener((GenericFutureListener)new ChannelCloseFutureListener());
        }
    }

    public void removeChannel(ChannelNotifyParams channel) {
        this.channels.remove(channel);
    }

    private class ChannelCloseFutureListener
    implements ChannelFutureListener {
        private ChannelCloseFutureListener() {
        }

        public void operationComplete(ChannelFuture channelCloseFuture) throws Exception {
            for (ChannelNotifyParams channel : CacheListener.this.channels) {
                if (channelCloseFuture.channel() != channel.channel) continue;
                CacheListener.this.removeChannel(channel);
            }
        }
    }

    public static class ChannelNotifyParams {
        private static final String[] DEFAULT_EVENTS = new String[]{Event.Type.CACHE_ENTRY_MODIFIED.toString(), Event.Type.CACHE_ENTRY_REMOVED.toString()};
        private Channel channel;
        private String key;
        private List<Event.Type> onEvents = new ArrayList<Event.Type>();

        public ChannelNotifyParams(Channel channel, String key, String[] onEvents) {
            if (channel == null) {
                logger.invalidNullArgument("channel");
            }
            String[] onEventsSpec = onEvents;
            this.channel = channel;
            this.key = key;
            if (onEventsSpec == null) {
                onEventsSpec = DEFAULT_EVENTS;
            }
            for (String eventType : onEventsSpec) {
                try {
                    this.onEvents.add(Event.Type.valueOf((String)eventType));
                }
                catch (RuntimeException e) {
                    logger.debug("Runtime exception on adding events", e);
                }
            }
            if (onEvents == null && key.equals("*")) {
                this.onEvents.add(Event.Type.CACHE_ENTRY_CREATED);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof ChannelNotifyParams) {
                ChannelNotifyParams channelNotifyParams = (ChannelNotifyParams)obj;
                if (channelNotifyParams.channel == this.channel) {
                    if (this.key == null) {
                        return channelNotifyParams.key == null;
                    }
                    return this.key.equals(channelNotifyParams.key);
                }
            }
            return false;
        }

        public int hashCode() {
            if (this.key != null) {
                return super.hashCode() + this.channel.hashCode() + this.key.hashCode();
            }
            return super.hashCode() + this.channel.hashCode();
        }
    }
}

