/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket;

import org.infinispan.assertions.JsonPayloadAssertion;
import org.infinispan.server.websocket.ChannelUtils;
import org.infinispan.server.websocket.json.JsonObject;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="websocket.ChannelUtilsTest", groups={"unit"})
public class ChannelUtilsTest {
    public void shouldReturnJsonObjectOnStringValue() throws Exception {
        String value = "new val";
        JsonObject jsonObject = ChannelUtils.toJSON((String)"key", (Object)value, (String)"cacheName");
        JsonPayloadAssertion.assertThat(jsonObject).hasValue("new val");
    }

    public void shouldReturnJsonObjectOnNumberValue() throws Exception {
        Integer value = 1;
        JsonObject jsonObject = ChannelUtils.toJSON((String)"key", (Object)value, (String)"cacheName");
        JsonPayloadAssertion.assertThat(jsonObject).hasValue(1);
    }

    public void shouldReturnJsonObjectOnCharacterValue() throws Exception {
        Character value = Character.valueOf('a');
        JsonObject jsonObject = ChannelUtils.toJSON((String)"key", (Object)value, (String)"cacheName");
        JsonPayloadAssertion.assertThat(jsonObject).hasValue(Character.valueOf('a'));
    }

    public void shouldReturnJsonObjectOnCustomClassValue() throws Exception {
        class CustomValue {
            String field1;

            CustomValue() {
            }

            public String getField1() {
                return this.field1;
            }

            public void setField1(String field1) {
                this.field1 = field1;
            }
        }
        CustomValue value = new CustomValue();
        value.field1 = "value";
        JsonObject jsonObject = ChannelUtils.toJSON((String)"key", (Object)value, (String)"cacheName");
        JsonPayloadAssertion.assertThat(jsonObject).hasValue("{\"field1\":\"value\"}");
    }

    public void shouldFailOnSerializingCustomClassWithoutGetters() throws Exception {
        class CustomValue {
            String field1;

            CustomValue() {
            }
        }
        CustomValue value = new CustomValue();
        value.field1 = "value";
        try {
            ChannelUtils.toJSON((String)"key", (Object)value, (String)"cacheName");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

