/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.CacheIgnoreAware;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.websocket.OpHandler;
import org.infinispan.server.websocket.WebSocketServerHandler;
import org.infinispan.server.websocket.handlers.GetHandler;
import org.infinispan.server.websocket.handlers.NotifyHandler;
import org.infinispan.server.websocket.handlers.PutHandler;
import org.infinispan.server.websocket.handlers.RemoveHandler;
import org.infinispan.server.websocket.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class WebSocketServer
extends AbstractProtocolServer {
    private static final Log logger = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    public static final String INFINISPAN_WS_JS_FILENAME = "infinispan-ws.js";
    private static String javascript;

    public WebSocketServer() {
        super("WebSocket");
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        return null;
    }

    public void startInternal(ProtocolServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        super.startInternal(configuration, cacheManager);
    }

    public ChannelInitializer<Channel> getInitializer() {
        return new WebSocketServerPipelineFactory((CacheContainer)this.cacheManager(), (CacheIgnoreAware)this);
    }

    public static String getJavascript() {
        if (javascript != null) {
            return javascript;
        }
        BufferedReader scriptReader = new BufferedReader(new InputStreamReader(WebSocketServer.class.getResourceAsStream(INFINISPAN_WS_JS_FILENAME)));
        try {
            StringWriter writer = new StringWriter();
            String line = scriptReader.readLine();
            while (line != null) {
                writer.write(line);
                writer.write(10);
                line = scriptReader.readLine();
            }
            String string = javascript = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw logger.unableToSendWebSocketsScriptToTheClient(e);
        }
        finally {
            try {
                scriptReader.close();
            }
            catch (IOException e) {
                throw logger.unableToCloseWebSocketsStream(e);
            }
        }
    }

    private static class WebSocketServerPipelineFactory
    extends ChannelInitializer<Channel> {
        private CacheContainer cacheContainer;
        private final CacheIgnoreAware cacheIgnoreAware;
        private Map<String, OpHandler> operationHandlers;
        private Map<String, Cache<Object, Object>> startedCaches = CollectionFactory.makeConcurrentMap();

        public WebSocketServerPipelineFactory(CacheContainer cacheContainer, CacheIgnoreAware cacheIgnoreAware) {
            this.cacheContainer = cacheContainer;
            this.cacheIgnoreAware = cacheIgnoreAware;
            this.operationHandlers = new HashMap<String, OpHandler>();
            this.operationHandlers.put("put", new PutHandler());
            this.operationHandlers.put("get", new GetHandler());
            this.operationHandlers.put("remove", new RemoveHandler());
            NotifyHandler notifyHandler = new NotifyHandler();
            this.operationHandlers.put("notify", notifyHandler);
            this.operationHandlers.put("unnotify", notifyHandler);
        }

        public void initChannel(Channel channel) throws Exception {
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            pipeline.addLast("handler", (ChannelHandler)new WebSocketServerHandler(this.cacheContainer, this.operationHandlers, this.startedCaches, this.cacheIgnoreAware));
        }
    }
}

