/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket.handlers;

import org.infinispan.assertions.JsonPayloadAssertion;
import org.infinispan.server.websocket.handlers.MockClient;
import org.infinispan.server.websocket.json.JsonObject;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.websocket.MockChannel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(testName="websocket.handlers.OpHandlerTest", groups={"unit"})
public class OpHandlerTest
extends AbstractInfinispanTest {
    public static final String CACHE_NAME = "cacheName";
    private MockChannel serverChannel;
    private MockClient cacheClient;

    @BeforeTest
    public void beforeTest() {
        this.serverChannel = new MockChannel();
        this.cacheClient = new MockClient(CACHE_NAME, this.serverChannel);
    }

    @AfterTest
    public void afterTest() {
        if (this.cacheClient != null) {
            this.cacheClient.stop();
        }
        if (this.serverChannel != null) {
            this.serverChannel.clear();
        }
    }

    public void shouldReturnPreviouslyPutValueInJsonPayload() throws Exception {
        this.cacheClient.put("a", "aVal");
        this.cacheClient.get("a");
        JsonObject payload = this.serverChannel.getJSONPayload();
        JsonPayloadAssertion.assertThat(payload).hasCacheName(CACHE_NAME).hasKey("a").hasValue("aVal").hasMimeType("text/plain");
    }

    public void shouldReturnNullWhenValueIsNotInCache() throws Exception {
        this.cacheClient.get("notInCache");
        JsonObject payload = this.serverChannel.getJSONPayload();
        JsonPayloadAssertion.assertThat(payload).hasCacheName(CACHE_NAME).hasKey("notInCache").hasValue(null);
    }

    public void shouldReturnPreviouslyPutValueOnNotify() throws Exception {
        this.cacheClient.put("a", "aVal");
        this.cacheClient.notify("a");
        JsonObject payload = this.serverChannel.getJSONPayload(1000L);
        JsonPayloadAssertion.assertThat(payload).hasKey("a").hasValue("aVal");
    }

    public void shouldCallNotifyIfModifyingValueInCache() throws Exception {
        this.cacheClient.put("a", "oldValue");
        this.cacheClient.notify("a");
        this.serverChannel.getJSONPayload(1000L);
        this.cacheClient.getCache().put((Object)"a", (Object)"newValue");
        JsonObject payload = this.serverChannel.getJSONPayload();
        JsonPayloadAssertion.assertThat(payload).hasKey("a").hasValue("newValue");
    }

    public void shouldNotCallNotifyWhenListeningToDataWithoutNotifications() throws Exception {
        this.cacheClient.put("notificationKey", "aVal");
        this.cacheClient.put("irrelevantKey", "bVal");
        this.cacheClient.notify("notificationKey");
        this.serverChannel.getJSONPayload();
        this.cacheClient.getCache().put((Object)"irrelevantKey", (Object)"newValue");
        try {
            JsonObject jsonPayload = this.serverChannel.getJSONPayload(250L);
            AssertJUnit.fail((String)("Expected timeout" + jsonPayload));
        }
        catch (RuntimeException e) {
            AssertJUnit.assertEquals((String)e.getMessage(), (String)"Timed out waiting for data to be pushed onto the channel.");
        }
    }

    @Test(dependsOnMethods={"shouldNotCallNotifyWhenListeningToDataWithoutNotifications", "shouldCallNotifyIfModifyingValueInCache"})
    public void shouldCallNotifyWhenListeningToAllNotifications() throws Exception {
        this.cacheClient.put("a", "aVal");
        this.cacheClient.put("b", "bVal");
        this.cacheClient.notify("*");
        this.serverChannel.getJSONPayload();
        this.cacheClient.getCache().put((Object)"b", (Object)"newValue");
        JsonObject payload = this.serverChannel.getJSONPayload();
        JsonPayloadAssertion.assertThat(payload).hasKey("b").hasValue("newValue");
    }

    public void shouldReturnPreviouslyPutValueOnRemove() throws Exception {
        this.cacheClient.put("a", "aVal");
        this.cacheClient.get("a");
        this.serverChannel.getJSONPayload();
        this.cacheClient.remove("a");
        this.cacheClient.get("a");
        JsonObject payload = this.serverChannel.getJSONPayload();
        JsonPayloadAssertion.assertThat(payload).hasCacheName(CACHE_NAME).hasKey("a").hasValue(null);
    }
}

