/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket.json;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.infinispan.assertions.JsonPayloadAssertion;
import org.infinispan.server.websocket.json.JsonObject;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="websocket.json.JsonObjectTest", groups={"unit"})
public class JsonObjectTest
extends AbstractInfinispanTest {
    public void shouldReadJsonObjectFromJavaObject() throws Exception {
        ExampleObject example = new ExampleObject("field1Val", "field2Val");
        JsonObject testedObject = JsonObject.fromObject((Object)example);
        JsonPayloadAssertion.assertThat(testedObject).hasFields("field1", "field1Val").hasFields("field2", "field2Val");
    }

    public void shouldReadJsonObjectFromMap() throws Exception {
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("field1", "field1Val");
        objectMap.put("field2", "field2Val");
        JsonObject testedObject = JsonObject.fromObject(objectMap);
        JsonPayloadAssertion.assertThat(testedObject).hasFields("field1", "field1Val").hasFields("field2", "field2Val");
    }

    public void shouldOverrideToStringMethod() throws Exception {
        LinkedHashMap<String, String> objectMap = new LinkedHashMap<String, String>();
        objectMap.put("field2", "field2Val");
        objectMap.put("field1", "field1Val");
        JsonObject testedObject = JsonObject.fromMap(objectMap);
        String json = testedObject.toString();
        Assert.assertEquals((String)"{\"field2\":\"field2Val\",\"field1\":\"field1Val\"}", (String)json);
    }

    private static class ExampleObject {
        String field1;
        String field2;

        ExampleObject(String field1, String field2) {
            this.field1 = field1;
            this.field2 = field2;
        }

        public String getField1() {
            return this.field1;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public String getField2() {
            return this.field2;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }
    }
}

