/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketClient;
import org.eclipse.jetty.websocket.WebSocketClientFactory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.websocket.WebSocketServer;
import org.infinispan.server.websocket.configuration.WebSocketServerConfigurationBuilder;
import org.infinispan.server.websocket.json.JsonObject;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="websocket.WebSocketServerIntegrationTest", groups={"functional"})
public class WebSocketServerIntegrationTest
extends SingleCacheManagerTest {
    private WebSocketServer wsServer;
    private WebSocketTestClient wsClient;
    String cacheName = "testCache";

    @BeforeMethod
    public void setUp() throws Exception {
        Cache cache = this.cacheManager.getCache(this.cacheName);
        cache.put((Object)"key", (Object)"value");
        this.wsServer = new WebSocketServer();
        this.wsServer.start((ProtocolServerConfiguration)((WebSocketServerConfigurationBuilder)((WebSocketServerConfigurationBuilder)new WebSocketServerConfigurationBuilder().host("localhost")).port(this.getFreePort())).build(), this.cacheManager);
        this.wsClient = new WebSocketTestClient(this.cacheName);
        this.wsClient.connect(new URI("ws://localhost:" + this.wsServer.getPort()));
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.wsServer.stop();
        this.wsClient.destroy();
    }

    @Test
    public void testGet() throws Exception {
        Assert.assertEquals((String)this.wsClient.get("key"), (String)"value");
    }

    @Test
    public void testPut() throws Exception {
        String key = "key2";
        String value = "value2";
        this.wsClient.put(key, value);
        Assert.assertEquals((String)this.wsClient.get(key), (String)value);
    }

    @Test
    public void testGarbage() throws Exception {
        JsonObject jsonObject = this.wsClient.sendAndWait("garbage");
        Assert.assertTrue((boolean)jsonObject.containsKey((Object)"error"));
    }

    @Test(expectedExceptions={Exception.class}, expectedExceptionsMessageRegExp="Cache temporarily unavailable")
    public void testDisableCache() throws Exception {
        Assert.assertEquals((String)this.wsClient.get("key"), (String)"value");
        this.wsServer.ignoreCache(this.cacheName);
        Assert.assertEquals((String)this.wsClient.get("key"), (String)"value");
    }

    private int getFreePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)new GlobalConfigurationBuilder().defaultCacheName(this.cacheName), (ConfigurationBuilder)new ConfigurationBuilder());
    }

    @NotThreadSafe
    private static class WebSocketTestClient {
        private final String cacheName;
        private final WebSocketClient wsClient;
        private final WebSocketClientFactory webSocketClientFactory;
        private CountDownLatch messageLatch = new CountDownLatch(1);
        private static final int TIMEOUT = 5;
        private static final TimeUnit TIMEOUT_UNIT = TimeUnit.SECONDS;
        private WebSocket.Connection connection;
        private String lastMessage;

        public WebSocketTestClient(String cacheName) throws Exception {
            this.cacheName = cacheName;
            this.webSocketClientFactory = new WebSocketClientFactory();
            this.webSocketClientFactory.start();
            this.wsClient = this.webSocketClientFactory.newWebSocketClient();
        }

        public void connect(URI serverURI) throws Exception {
            this.connection = (WebSocket.Connection)this.wsClient.open(serverURI, (WebSocket)new ClientWebSocket()).get(2L, TimeUnit.SECONDS);
        }

        public void destroy() throws Exception {
            this.webSocketClientFactory.stop();
            this.connection.close();
        }

        public void put(String key, String value) throws Exception {
            JsonObject jsonObject = JsonObject.createNew();
            jsonObject.put("opCode", (Object)"put");
            jsonObject.put("cacheName", (Object)this.cacheName);
            jsonObject.put("key", (Object)key);
            jsonObject.put("value", (Object)value);
            jsonObject.put("mime", (Object)"text/plain");
            this.connection.sendMessage(jsonObject.toString());
        }

        public JsonObject sendAndWait(String message) throws Exception {
            this.messageLatch = new CountDownLatch(1);
            this.connection.sendMessage(message);
            this.messageLatch.await(5L, TIMEOUT_UNIT);
            return JsonObject.fromString((String)this.lastMessage);
        }

        public String get(String key) throws Exception {
            JsonObject jsonObject = JsonObject.createNew();
            jsonObject.put("opCode", (Object)"get");
            jsonObject.put("cacheName", (Object)this.cacheName);
            jsonObject.put("key", (Object)key);
            JsonObject response = this.sendAndWait(jsonObject.toString());
            if (response.containsKey((Object)"error")) {
                throw new Exception(response.get((Object)"error").toString());
            }
            return response.get((Object)"value").toString();
        }

        private class ClientWebSocket
        implements WebSocket.OnTextMessage {
            private ClientWebSocket() {
            }

            public void onMessage(String data) {
                WebSocketTestClient.this.lastMessage = data;
                WebSocketTestClient.this.messageLatch.countDown();
            }

            public void onOpen(WebSocket.Connection connection) {
            }

            public void onClose(int closeCode, String message) {
            }
        }
    }
}

