/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.integrationtests.spring.boot.session;

import org.infinispan.integrationtests.spring.boot.session.configuration.InfinispanSessionListener;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.http.HttpHeaders;
import org.springframework.session.MapSession;
import org.springframework.session.SessionRepository;

public class AbstractSpringSessionTCK {
    @Autowired
    private SessionRepository<MapSession> sessionRepository;
    @Autowired
    protected InfinispanSessionListener httpSessionListener;
    @LocalServerPort
    private int port;

    @Test
    public void testCreatingSessionWhenUsingREST() {
        Assert.assertNull((Object)this.httpSessionListener.getCreatedSession());
        Assert.assertNull((Object)this.httpSessionListener.getDestroyedSession());
        TestRestTemplate restTemplate = new TestRestTemplate("user", "password", new TestRestTemplate.HttpClientOption[0]);
        HttpHeaders httpHeaders = restTemplate.headForHeaders(this.getTestURL(), new Object[0]);
        Assert.assertNotNull((Object)this.sessionRepository.findById(this.getSessionId(httpHeaders)));
        Assert.assertNotNull((Object)this.httpSessionListener.getCreatedSession());
        this.sessionRepository.deleteById(this.getSessionId(httpHeaders));
        Assert.assertNotNull((Object)this.httpSessionListener.getDestroyedSession());
    }

    private String getTestURL() {
        return "http://localhost:" + this.port + "/test";
    }

    private String getSessionId(HttpHeaders httpHeaders) {
        return (String)httpHeaders.getValuesAsList("x-auth-token").get(0);
    }
}

