/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.integrationtests.spring.boot.session;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.embedded.LocalServerPort;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.session.MapSession;
import org.springframework.session.SessionRepository;

public class AbstractSpringSessionTCK {
    @Autowired
    private SessionRepository<MapSession> sessionRepository;
    @LocalServerPort
    private int port;

    @Test
    public void testCreatingSessionWhenUsingREST() throws Exception {
        TestRestTemplate restTemplate = new TestRestTemplate("user", "password", new TestRestTemplate.HttpClientOption[0]);
        HttpHeaders httpHeaders = restTemplate.headForHeaders(this.getTestURL(), new Object[0]);
        Assert.assertNotNull((Object)this.sessionRepository.getSession(this.getSessionId(httpHeaders)));
    }

    private String getTestURL() {
        return "http://localhost:" + this.port + "/test";
    }

    private String getSessionId(HttpHeaders httpHeaders) {
        return (String)httpHeaders.getValuesAsList("x-auth-token").get(0);
    }
}

