/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tutorial.simple.spring.remote;

import java.lang.invoke.MethodHandles;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.tutorial.simple.spring.remote.BasqueNamesRepository;
import org.infinispan.tutorial.simple.spring.remote.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class Reader {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final BasqueNamesRepository repository;
    private final Random random;
    private final RemoteCache<Integer, String> cache;

    public Reader(BasqueNamesRepository repository, RemoteCacheManager remoteCacheManager) {
        this.repository = repository;
        this.random = new Random();
        this.cache = remoteCacheManager.administration().getOrCreateCache("basque-names", "default");
        try {
            this.cache.clearAsync().get(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            logger.warn("Unable to clear the cache");
        }
    }

    @Scheduled(fixedDelay=10000L)
    public void retrieveSize() {
        logger.info(">>>> Cache size " + this.cache.size());
        logger.info(">>>> Database size " + this.repository.size());
    }

    @Scheduled(fixedDelay=1000L)
    public void createOne() {
        int id = this.random.nextInt(Data.NAMES.size());
        this.repository.create(id, (String)Data.NAMES.get(id));
    }

    @Scheduled(fixedDelay=3000L)
    public void removeOne() {
        int id = this.random.nextInt(Data.NAMES.size());
        this.repository.removeById(id);
    }

    @Scheduled(fixedDelay=1000L)
    public void retrieveBasqueName() {
        int id = this.random.nextInt(Data.NAMES.size());
        logger.info("FIND RESULT " + this.repository.findById(id));
    }
}

