/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tutorial.simple.spring.remote;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.infinispan.tutorial.simple.spring.remote.BasqueName;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
@CacheConfig(cacheNames={"basque-names"})
public class BasqueNamesRepository {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass().getName());
    private Map<Integer, BasqueName> database = new HashMap();

    @Cacheable
    public BasqueName findById(int id) {
        logger.info("Call database to FIND name by id '" + id + "'");
        return (BasqueName)this.database.get(id);
    }

    public void create(int id, String name) {
        logger.info("Call database to CREATE name by id '" + id + "'");
        this.database.put(id, new BasqueName(id, name));
    }

    @CacheEvict
    public void removeById(int id) {
        logger.info("Call database to REMOVE name by id '" + id + "'");
        this.database.remove(id);
    }

    public int size() {
        return this.database.size();
    }
}

