/*
 * Decompiled with CFR 0.152.
 */
package infinispan.autoconfigure.embedded;

import infinispan.autoconfigure.common.InfinispanProperties;
import infinispan.autoconfigure.embedded.InfinispanCacheConfigurer;
import infinispan.autoconfigure.embedded.InfinispanGlobalConfigurer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan
@ConditionalOnClass(name={"org.infinispan.manager.EmbeddedCacheManager"})
@ConditionalOnProperty(value={"infinispan.embedded.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={InfinispanProperties.class})
public class InfinispanEmbeddedAutoConfiguration {
    public static final String DEFAULT_JMX_DOMAIN = "infinispan";
    @Autowired
    private InfinispanProperties infinispanProperties;
    @Autowired(required=false)
    private List<InfinispanCacheConfigurer> configurers = Collections.emptyList();
    @Autowired(required=false)
    private InfinispanGlobalConfigurer infinispanGlobalConfigurer;

    @Bean(destroyMethod="stop")
    public DefaultCacheManager defaultCacheManager() throws IOException {
        String configXml = this.infinispanProperties.getEmbedded().getConfigXml();
        GlobalConfiguration defaultGlobalConfiguration = new GlobalConfigurationBuilder().globalJmxStatistics().jmxDomain(DEFAULT_JMX_DOMAIN).enable().transport().clusterName(this.infinispanProperties.getEmbedded().getClusterName()).build();
        org.infinispan.configuration.cache.Configuration defaultConfiguration = new ConfigurationBuilder().build();
        GlobalConfiguration globalConfiguration = this.infinispanGlobalConfigurer == null ? defaultGlobalConfiguration : this.infinispanGlobalConfigurer.getGlobalConfiguration();
        DefaultCacheManager manager = configXml.isEmpty() ? new DefaultCacheManager(globalConfiguration, defaultConfiguration) : new DefaultCacheManager(configXml);
        this.configureCaches((EmbeddedCacheManager)manager);
        return manager;
    }

    private void configureCaches(EmbeddedCacheManager manager) {
        this.configurers.forEach(configurer -> configurer.configureCache(manager));
    }
}

