/*
 * Decompiled with CFR 0.152.
 */
package test.org.infinispan.spring.starter.embedded;

import org.assertj.core.api.Assertions;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.embedded.provider.SpringEmbeddedCacheManager;
import org.infinispan.spring.starter.embedded.InfinispanEmbeddedAutoConfiguration;
import org.infinispan.spring.starter.embedded.InfinispanEmbeddedCacheManagerAutoConfiguration;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest(classes={InfinispanEmbeddedAutoConfiguration.class, InfinispanEmbeddedCacheManagerAutoConfiguration.class}, properties={"spring.main.banner-mode=off"})
public class InfinispanEmbeddedAutoConfigurationIntegrationTest {
    @Autowired
    EmbeddedCacheManager defaultCacheManager;
    @Autowired
    SpringEmbeddedCacheManager springEmbeddedCacheManager;

    @Test
    public void testAutowired() {
        Assertions.assertThat((Object)this.defaultCacheManager).isNotNull();
    }

    @Test
    public void testDefaultConfigurations() {
        Assertions.assertThat((String)this.defaultCacheManager.getClusterName()).isEqualTo((Object)"default-autoconfigure");
        Assertions.assertThat((Iterable)this.defaultCacheManager.getCacheNames()).containsExactly((Object[])new String[]{"default"});
        Configuration defaultCacheConfiguration = this.defaultCacheManager.getDefaultCacheConfiguration();
        Assertions.assertThat((Object)defaultCacheConfiguration).isNull();
        GlobalConfiguration globalConfiguration = this.defaultCacheManager.getCacheManagerConfiguration();
        Assertions.assertThat((boolean)globalConfiguration.jmx().enabled()).isTrue();
        Assertions.assertThat((String)globalConfiguration.jmx().domain()).isEqualTo((Object)"org.infinispan");
    }

    @Test
    public void testIfSpringCachingWasCreatedUsingProperEmbeddedCacheManager() throws Exception {
        Assertions.assertThat((Object)this.defaultCacheManager).isEqualTo((Object)this.springEmbeddedCacheManager.getNativeCacheManager());
    }
}

