/*
 * Decompiled with CFR 0.152.
 */
package test.org.infinispan.spring.starter.embedded;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.starter.embedded.InfinispanEmbeddedAutoConfiguration;
import org.infinispan.spring.starter.embedded.InfinispanEmbeddedCacheManagerAutoConfiguration;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.TestPropertySource;

@SpringBootTest(classes={InfinispanEmbeddedAutoConfiguration.class, InfinispanEmbeddedCacheManagerAutoConfiguration.class}, properties={"spring.main.banner-mode=off"})
@TestPropertySource(properties={"infinispan.embedded.config-xml=infinispan-test-conf.xml"})
public class InfinispanEmbeddedAutoConfigurationPropertiesTest {
    @Autowired
    EmbeddedCacheManager defaultCacheManager;

    @Test
    public void testCacheManagerXmlConfig() {
        Assertions.assertThat((Iterable)this.defaultCacheManager.getCacheNames()).isEqualTo(Collections.singleton("default-local"));
        GlobalConfiguration globalConfiguration = this.defaultCacheManager.getCacheManagerConfiguration();
        Assertions.assertThat((boolean)globalConfiguration.globalJmxStatistics().enabled()).isTrue();
        Assertions.assertThat((String)globalConfiguration.globalJmxStatistics().domain()).isEqualTo((Object)"properties.test.spring.infinispan");
        Configuration defaultCacheConfiguration = this.defaultCacheManager.getDefaultCacheConfiguration();
        Assertions.assertThat((long)defaultCacheConfiguration.memory().size()).isEqualTo(2000L);
    }
}

