/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.starter.embedded.actuator;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.cache.JCacheMetrics;
import org.infinispan.Cache;
import org.infinispan.spring.starter.embedded.actuator.InfinispanCacheMeterBinder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.metrics.cache.CacheMeterBinderProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="infinispanCacheMeterBinderProvider")
@ConditionalOnClass(name={"org.springframework.boot.actuate.metrics.cache.CacheMeterBinderProvider"})
@ConditionalOnProperty(value={"infinispan.embedded.enabled"}, havingValue="true", matchIfMissing=true)
public class InfinispanCacheMeterBinderProvider
implements CacheMeterBinderProvider<org.springframework.cache.Cache> {
    public static final String NAME = "infinispanCacheMeterBinderProvider";

    public MeterBinder getMeterBinder(org.springframework.cache.Cache cache, Iterable<Tag> tags) {
        Object nativeCache = cache.getNativeCache();
        InfinispanCacheMeterBinder meterBinder = null;
        if (nativeCache instanceof Cache) {
            meterBinder = new InfinispanCacheMeterBinder((Cache)nativeCache, tags);
        } else if (nativeCache instanceof javax.cache.Cache) {
            meterBinder = new JCacheMetrics((javax.cache.Cache)nativeCache, tags);
        }
        return meterBinder;
    }
}

