/*
 * Decompiled with CFR 0.152.
 */
package test.org.infinispan.spring.starter.embedded.actuator;

import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinderCompatibilityKit;
import java.util.Collections;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.spring.starter.embedded.actuator.InfinispanCacheMeterBinder;
import org.junit.jupiter.api.AfterAll;

public class InfinispanCacheMetricBinderTest
extends CacheMeterBinderCompatibilityKit {
    private static EmbeddedCacheManager cacheManager;
    private Cache<String, String> cache;

    @AfterAll
    public static void cleanup() {
        cacheManager.stop();
    }

    public CacheMeterBinder binder() {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.metrics().accurateSize(true);
        cacheManager = new DefaultCacheManager(global.build());
        this.cache = ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).getOrCreateCache("mycache", new ConfigurationBuilder().jmxStatistics().enable().build());
        return new InfinispanCacheMeterBinder(this.cache, Collections.emptyList());
    }

    public void put(String key, String value) {
        this.cache.put((Object)key, (Object)value);
    }

    public String get(String key) {
        return (String)this.cache.get((Object)key);
    }
}

