/*
 * Decompiled with CFR 0.152.
 */
package test.org.infinispan.spring.starter.remote;

import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ClusterConfiguration;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.impl.async.DefaultAsyncExecutorFactory;
import org.infinispan.client.hotrod.security.BasicCallbackHandler;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.spring.starter.remote.InfinispanRemoteAutoConfiguration;
import org.infinispan.spring.starter.remote.InfinispanRemoteCacheManagerAutoConfiguration;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.TestPropertySource;

@SpringBootTest(classes={InfinispanRemoteAutoConfiguration.class, InfinispanRemoteCacheManagerAutoConfiguration.class}, properties={"spring.main.banner-mode=off"})
@TestPropertySource(locations={"classpath:test-application.properties"})
public class ApplicationPropertiesTest {
    @Autowired
    private RemoteCacheManager remoteCacheManager;

    @Test
    public void testDefaultClient() throws Exception {
        Configuration configuration = this.remoteCacheManager.getConfiguration();
        String hostObtainedFromPropertiesFile = ((ServerConfiguration)configuration.servers().get(0)).host();
        int portObtainedFromPropertiesFile = ((ServerConfiguration)configuration.servers().get(0)).port();
        configuration.asyncExecutorFactory().factoryClass();
        Assertions.assertThat((String)hostObtainedFromPropertiesFile).isEqualTo((Object)"180.567.112.333");
        Assertions.assertThat((int)portObtainedFromPropertiesFile).isEqualTo(6668);
        Assertions.assertThat((boolean)configuration.tcpNoDelay()).isFalse();
        Assertions.assertThat((boolean)configuration.tcpKeepAlive()).isTrue();
        Assertions.assertThat((Comparable)configuration.clientIntelligence()).isEqualTo((Object)ClientIntelligence.TOPOLOGY_AWARE);
        Assertions.assertThat((int)configuration.socketTimeout()).isEqualTo(500);
        Assertions.assertThat((int)configuration.connectionTimeout()).isEqualTo(200);
        Assertions.assertThat((int)configuration.maxRetries()).isEqualTo(30);
        Assertions.assertThat((int)configuration.batchSize()).isEqualTo(91);
        Assertions.assertThat((Comparable)configuration.version()).isEqualTo((Object)ProtocolVersion.PROTOCOL_VERSION_24);
        Assertions.assertThat((int)configuration.connectionPool().maxActive()).isEqualTo(90);
        Assertions.assertThat((long)configuration.connectionPool().maxWait()).isEqualTo(20000L);
        Assertions.assertThat((int)configuration.connectionPool().minIdle()).isEqualTo(1000);
        Assertions.assertThat((int)configuration.connectionPool().maxPendingRequests()).isEqualTo(845);
        Assertions.assertThat((long)configuration.connectionPool().minEvictableIdleTime()).isEqualTo(9000L);
        Assertions.assertThat((Comparable)configuration.connectionPool().exhaustedAction()).isEqualTo((Object)ExhaustedAction.CREATE_NEW);
        Assertions.assertThat((Class)configuration.asyncExecutorFactory().factoryClass()).isEqualTo(DefaultAsyncExecutorFactory.class);
        Assertions.assertThat((Class)configuration.marshallerClass()).isEqualTo(JavaSerializationMarshaller.class);
        Assertions.assertThat((int)configuration.keySizeEstimate()).isEqualTo(88889);
        Assertions.assertThat((int)configuration.valueSizeEstimate()).isEqualTo(11112);
        Assertions.assertThat((boolean)configuration.forceReturnValues()).isTrue();
        Assertions.assertThat((List)configuration.serialWhitelist()).contains((Object[])new String[]{"APP-KILLER1", "APP-KILLER2"});
        Assertions.assertThat((boolean)configuration.security().ssl().enabled()).isTrue();
        Assertions.assertThat((String)configuration.security().ssl().keyStoreFileName()).isEqualTo((Object)"superKeyStoreFile");
        Assertions.assertThat((String)configuration.security().ssl().keyStoreType()).isEqualTo((Object)"SKL");
        Assertions.assertThat((int)configuration.security().ssl().keyStorePassword().length).isEqualTo(17);
        Assertions.assertThat((String)configuration.security().ssl().keyAlias()).isEqualTo((Object)"superAliasKey");
        Assertions.assertThat((char[])configuration.security().ssl().keyStoreCertificatePassword()).hasSize(13);
        Assertions.assertThat((String)configuration.security().ssl().trustStoreFileName()).isEqualTo((Object)"superTrustFileName");
        Assertions.assertThat((String)configuration.security().ssl().trustStorePath()).isNull();
        Assertions.assertThat((String)configuration.security().ssl().trustStoreType()).isEqualTo((Object)"CKO");
        Assertions.assertThat((int)configuration.security().ssl().trustStorePassword().length).isEqualTo(18);
        Assertions.assertThat((String)configuration.security().ssl().sniHostName()).isEqualTo((Object)"elahost");
        Assertions.assertThat((String)configuration.security().ssl().protocol()).isEqualTo((Object)"TLSv1.4");
        Assertions.assertThat((boolean)configuration.security().authentication().enabled()).isTrue();
        Assertions.assertThat(configuration.security().authentication().callbackHandler().getClass()).isEqualTo(BasicCallbackHandler.class);
        Assertions.assertThat((String)configuration.security().authentication().saslMechanism()).isEqualTo((Object)"my-sasl-mechanism");
        Assertions.assertThat((String)configuration.security().authentication().serverName()).isEqualTo((Object)"my-server-name");
        BasicCallbackHandler basicCallbackHandler = (BasicCallbackHandler)configuration.security().authentication().callbackHandler();
        NameCallback nameCallback = new NameCallback("test", "test");
        PasswordCallback passwordCallback = new PasswordCallback("test", false);
        RealmCallback realmCallback = new RealmCallback("test", "test");
        basicCallbackHandler.handle(new Callback[]{nameCallback, passwordCallback, realmCallback});
        Assertions.assertThat((String)nameCallback.getName()).isEqualTo((Object)"oihana");
        Assertions.assertThat((char[])passwordCallback.getPassword()).isEqualTo((Object)"oipass".toCharArray());
        Assertions.assertThat((String)realmCallback.getText()).isEqualTo((Object)"oirealm");
        Assertions.assertThat((Map)configuration.security().authentication().saslProperties()).hasSize(2);
        Assertions.assertThat((Map)configuration.security().authentication().saslProperties()).containsKeys((Object[])new String[]{"prop1", "prop2"});
        Assertions.assertThat((Map)configuration.security().authentication().saslProperties()).containsValues((Object[])new String[]{"value1", "value2"});
        Assertions.assertThat((Comparable)configuration.transaction().transactionMode()).isEqualTo((Object)TransactionMode.NON_DURABLE_XA);
        Assertions.assertThat((long)configuration.transaction().timeout()).isEqualTo(50000L);
        Assertions.assertThat((Comparable)configuration.nearCache().mode()).isEqualTo((Object)NearCacheMode.INVALIDATED);
        Assertions.assertThat((int)configuration.nearCache().maxEntries()).isEqualTo(2000);
        Assertions.assertThat((String)configuration.nearCache().cacheNamePattern().pattern()).isEqualTo((Object)"appCache*");
        Assertions.assertThat((List)configuration.clusters()).hasSize(1);
        ClusterConfiguration site = (ClusterConfiguration)configuration.clusters().get(0);
        Assertions.assertThat((List)site.getCluster()).extracting(new String[]{"host", "port"}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"hostOi1", 21222}), Tuple.tuple((Object[])new Object[]{"hostOi2", 21223})});
        Assertions.assertThat((boolean)configuration.statistics().enabled()).isTrue();
        Assertions.assertThat((boolean)configuration.statistics().jmxEnabled()).isTrue();
        Assertions.assertThat((String)configuration.statistics().jmxName()).isEqualTo((Object)"oiJmx");
        Assertions.assertThat((String)configuration.statistics().jmxDomain()).isEqualTo((Object)"oiJmxDom");
    }
}

