/*
 * Decompiled with CFR 0.152.
 */
package test.org.infinispan.spring.starter.remote;

import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ClusterConfiguration;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.impl.async.DefaultAsyncExecutorFactory;
import org.infinispan.client.hotrod.security.BasicCallbackHandler;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.spring.starter.remote.InfinispanRemoteAutoConfiguration;
import org.infinispan.spring.starter.remote.InfinispanRemoteCacheManagerAutoConfiguration;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest(classes={InfinispanRemoteAutoConfiguration.class, InfinispanRemoteCacheManagerAutoConfiguration.class}, properties={"spring.main.banner-mode=off", "infinispan.remote.client-properties=custom-test-hotrod-client.properties"})
public class CustomPropertiesTest {
    @Autowired
    private RemoteCacheManager remoteCacheManager;

    @Test
    public void testDefaultClient() throws Exception {
        Configuration configuration = this.remoteCacheManager.getConfiguration();
        String hostObtainedFromPropertiesFile = ((ServerConfiguration)configuration.servers().get(0)).host();
        int portObtainedFromPropertiesFile = ((ServerConfiguration)configuration.servers().get(0)).port();
        Assertions.assertThat((String)hostObtainedFromPropertiesFile).isEqualTo((Object)"127.0.0.1");
        Assertions.assertThat((int)portObtainedFromPropertiesFile).isEqualTo(6667);
        Assertions.assertThat((boolean)configuration.tcpNoDelay()).isFalse();
        Assertions.assertThat((boolean)configuration.tcpKeepAlive()).isTrue();
        Assertions.assertThat((Comparable)configuration.clientIntelligence()).isEqualTo((Object)ClientIntelligence.TOPOLOGY_AWARE);
        Assertions.assertThat((int)configuration.socketTimeout()).isEqualTo(3000);
        Assertions.assertThat((int)configuration.connectionTimeout()).isEqualTo(5000);
        Assertions.assertThat((int)configuration.maxRetries()).isEqualTo(42);
        Assertions.assertThat((int)configuration.batchSize()).isEqualTo(90);
        Assertions.assertThat((Comparable)configuration.version()).isEqualTo((Object)ProtocolVersion.PROTOCOL_VERSION_28);
        Assertions.assertThat((int)configuration.connectionPool().maxActive()).isEqualTo(91);
        Assertions.assertThat((Comparable)configuration.connectionPool().exhaustedAction()).isEqualTo((Object)ExhaustedAction.EXCEPTION);
        Assertions.assertThat((long)configuration.connectionPool().maxWait()).isEqualTo(20001L);
        Assertions.assertThat((int)configuration.connectionPool().minIdle()).isEqualTo(1001);
        Assertions.assertThat((long)configuration.connectionPool().minEvictableIdleTime()).isEqualTo(9001L);
        Assertions.assertThat((int)configuration.connectionPool().maxPendingRequests()).isEqualTo(846);
        Assertions.assertThat((Class)configuration.asyncExecutorFactory().factoryClass()).isEqualTo(DefaultAsyncExecutorFactory.class);
        Assertions.assertThat((Class)configuration.marshallerClass()).isEqualTo(JavaSerializationMarshaller.class);
        Assertions.assertThat((int)configuration.keySizeEstimate()).isEqualTo(123456);
        Assertions.assertThat((int)configuration.valueSizeEstimate()).isEqualTo(789012);
        Assertions.assertThat((boolean)configuration.forceReturnValues()).isTrue();
        Assertions.assertThat((List)configuration.serialWhitelist()).contains((Object[])new String[]{"SERIAL-KILLER"});
        Assertions.assertThat((boolean)configuration.security().ssl().enabled()).isTrue();
        Assertions.assertThat((String)configuration.security().ssl().keyStoreFileName()).isEqualTo((Object)"keyStoreFile");
        Assertions.assertThat((String)configuration.security().ssl().keyStoreType()).isEqualTo((Object)"JKS");
        Assertions.assertThat((char[])configuration.security().ssl().keyStorePassword()).hasSize(12);
        Assertions.assertThat((String)configuration.security().ssl().keyAlias()).isEqualTo((Object)"aliasKey");
        Assertions.assertThat((char[])configuration.security().ssl().keyStoreCertificatePassword()).hasSize(9);
        Assertions.assertThat((String)configuration.security().ssl().trustStoreFileName()).isEqualTo((Object)"trustFileName");
        Assertions.assertThat((String)configuration.security().ssl().trustStorePath()).isNull();
        Assertions.assertThat((String)configuration.security().ssl().trustStoreType()).isEqualTo((Object)"LOL");
        Assertions.assertThat((int)configuration.security().ssl().trustStorePassword().length).isEqualTo(13);
        Assertions.assertThat((String)configuration.security().ssl().sniHostName()).isEqualTo((Object)"oihost");
        Assertions.assertThat((String)configuration.security().ssl().protocol()).isEqualTo((Object)"TLSv1.3");
        Assertions.assertThat((boolean)configuration.security().authentication().enabled()).isTrue();
        Assertions.assertThat((String)configuration.security().authentication().saslMechanism()).isEqualTo((Object)"DIGEST-MD5");
        Assertions.assertThat((Object)configuration.security().authentication().callbackHandler()).isInstanceOf(BasicCallbackHandler.class);
        Assertions.assertThat((String)configuration.security().authentication().serverName()).isEqualTo((Object)"my_ela_server_name");
        BasicCallbackHandler basicCallbackHandler = (BasicCallbackHandler)configuration.security().authentication().callbackHandler();
        NameCallback nameCallback = new NameCallback("test", "test");
        PasswordCallback passwordCallback = new PasswordCallback("test", false);
        RealmCallback realmCallback = new RealmCallback("test", "test");
        basicCallbackHandler.handle(new Callback[]{nameCallback, passwordCallback, realmCallback});
        Assertions.assertThat((String)nameCallback.getName()).isEqualTo((Object)"elaia");
        Assertions.assertThat((char[])passwordCallback.getPassword()).isEqualTo((Object)"elapass".toCharArray());
        Assertions.assertThat((String)realmCallback.getText()).isEqualTo((Object)"elarealm");
        Assertions.assertThat((Map)configuration.security().authentication().saslProperties()).hasSize(1);
        Assertions.assertThat((Map)configuration.security().authentication().saslProperties()).containsOnlyKeys((Object[])new String[]{"prop1"});
        Assertions.assertThat((Map)configuration.security().authentication().saslProperties()).containsValues((Object[])new String[]{"value1"});
        Assertions.assertThat((Comparable)configuration.transaction().transactionMode()).isEqualTo((Object)TransactionMode.FULL_XA);
        Assertions.assertThat((long)configuration.transaction().timeout()).isEqualTo(50001L);
        Assertions.assertThat((Comparable)configuration.nearCache().mode()).isEqualTo((Object)NearCacheMode.INVALIDATED);
        Assertions.assertThat((int)configuration.nearCache().maxEntries()).isEqualTo(10000);
        Assertions.assertThat((String)configuration.nearCache().cacheNamePattern().pattern()).isEqualTo((Object)"nearSuperCache*");
        Assertions.assertThat((List)configuration.clusters()).hasSize(2);
        ClusterConfiguration siteA = (ClusterConfiguration)configuration.clusters().get(0);
        ClusterConfiguration siteB = (ClusterConfiguration)configuration.clusters().get(1);
        Assertions.assertThat((String)siteA.getClusterName()).isEqualTo((Object)"siteA");
        Assertions.assertThat((String)siteB.getClusterName()).isEqualTo((Object)"siteB");
        Assertions.assertThat((List)siteA.getCluster()).extracting(new String[]{"host", "port"}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"hostA1", 11222}), Tuple.tuple((Object[])new Object[]{"hostA2", 11223})});
        Assertions.assertThat((List)siteB.getCluster()).extracting(new String[]{"host", "port"}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"hostB1", 11224}), Tuple.tuple((Object[])new Object[]{"hostB2", 11225})});
        Assertions.assertThat((boolean)configuration.statistics().enabled()).isTrue();
        Assertions.assertThat((boolean)configuration.statistics().jmxEnabled()).isTrue();
        Assertions.assertThat((String)configuration.statistics().jmxName()).isEqualTo((Object)"elaJmx");
        Assertions.assertThat((String)configuration.statistics().jmxDomain()).isEqualTo((Object)"elaJmxDom2");
    }
}

