/*
 * Decompiled with CFR 0.152.
 */
package test.org.infinispan.spring.starter.remote;

import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.spring.remote.provider.SpringRemoteCacheManager;
import org.infinispan.spring.starter.remote.InfinispanRemoteAutoConfiguration;
import org.infinispan.spring.starter.remote.InfinispanRemoteCacheManagerAutoConfiguration;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import test.org.infinispan.spring.starter.remote.testconfiguration.InfinispanCacheTestConfiguration;

@SpringBootTest(classes={InfinispanRemoteAutoConfiguration.class, InfinispanRemoteCacheManagerAutoConfiguration.class, InfinispanCacheTestConfiguration.class}, properties={"spring.main.banner-mode=off", "infinispan.remote.client-properties=test-hotrod-client.properties"})
public class IntegrationTest {
    @Autowired
    private RemoteCacheManager remoteCacheManager;
    @Autowired
    private SpringRemoteCacheManager springRemoteCacheManager;

    @Test
    public void testConfiguredClient() {
        int portObtainedFromPropertiesFile = ((ServerConfiguration)this.remoteCacheManager.getConfiguration().servers().get(0)).port();
        Assertions.assertThat((int)portObtainedFromPropertiesFile).isEqualTo(11555);
    }

    @Test
    public void testIfSpringCachingWasCreatedUsingProperEmbeddedCacheManager() throws Exception {
        Assertions.assertThat((Object)this.remoteCacheManager).isEqualTo((Object)this.springRemoteCacheManager.getNativeCacheManager());
    }
}

