/*
 * Decompiled with CFR 0.152.
 */
package test.org.infinispan.spring.starter.remote;

import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.spring.starter.remote.InfinispanRemoteAutoConfiguration;
import org.infinispan.spring.starter.remote.InfinispanRemoteConfigurer;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@SpringBootTest(classes={TestConfiguration.class, InfinispanRemoteAutoConfiguration.class}, properties={"spring.main.banner-mode=off", "myServerList=localhost:6667"})
public class CustomConfigurerWithPropertyInjectionTest {
    @Autowired
    private RemoteCacheManager manager;

    @Test
    public void testConfiguredClient() {
        Assertions.assertThat((int)((ServerConfiguration)this.manager.getConfiguration().servers().get(0)).port()).isEqualTo(6667);
    }

    @Configuration
    static class TestConfiguration {
        @Value(value="${myServerList}")
        private String serverList;

        TestConfiguration() {
        }

        @Bean
        public InfinispanRemoteConfigurer configuration() {
            return () -> new ConfigurationBuilder().addServers(this.serverList).build();
        }
    }
}

