/*
 * Decompiled with CFR 0.152.
 */
package test.org.infinispan.spring.starter.remote;

import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.spring.starter.remote.InfinispanRemoteAutoConfiguration;
import org.infinispan.spring.starter.remote.InfinispanRemoteCacheCustomizer;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@SpringBootTest(classes={TestConfiguration.class, InfinispanRemoteAutoConfiguration.class}, properties={"spring.main.banner-mode=off"})
public class CustomConfigurationTest {
    @Autowired
    private RemoteCacheManager manager;

    @Test
    public void testConfiguredClient() {
        Assertions.assertThat((int)((ServerConfiguration)this.manager.getConfiguration().servers().get(0)).port()).isEqualTo(6667);
        Assertions.assertThat((boolean)this.manager.getConfiguration().tcpNoDelay()).isFalse();
        Assertions.assertThat((boolean)this.manager.getConfiguration().tcpKeepAlive()).isFalse();
    }

    @org.springframework.context.annotation.Configuration
    static class TestConfiguration {
        TestConfiguration() {
        }

        @Bean
        public Configuration customConfiguration() {
            return new ConfigurationBuilder().addServers("127.0.0.1:6667").tcpNoDelay(false).tcpKeepAlive(true).build();
        }

        @Order(value=-2147483648)
        @Bean
        public InfinispanRemoteCacheCustomizer customizer() {
            return b -> b.tcpKeepAlive(false);
        }
    }
}

