/*
 * Decompiled with CFR 0.152.
 */
package test.org.infinispan.spring.starter.remote.actuator;

import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinderCompatibilityKit;
import java.util.Collections;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.XMLStringConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.junit5.InfinispanServerExtension;
import org.infinispan.server.test.junit5.InfinispanServerExtensionBuilder;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.starter.remote.actuator.RemoteInfinispanCacheMeterBinderProvider;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.springframework.cache.Cache;

public class RemoteCacheMetricBinderTest
extends CacheMeterBinderCompatibilityKit {
    @RegisterExtension
    static InfinispanServerExtension infinispanServerExtension = InfinispanServerExtensionBuilder.server();
    private RemoteCache<String, String> cache;

    public CacheMeterBinder binder() {
        org.infinispan.configuration.cache.ConfigurationBuilder serverBuilder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        serverBuilder.clustering().cacheMode(CacheMode.DIST_SYNC);
        XMLStringConfiguration stringConfiguration = new XMLStringConfiguration(serverBuilder.build().toXMLString("mycache"));
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.statistics().enable();
        clientBuilder.security().authentication().username(TestUser.ADMIN.getUser()).password(TestUser.ADMIN.getPassword());
        RemoteCacheManager remoteCacheManager = infinispanServerExtension.hotrod().withClientConfiguration(clientBuilder).createRemoteCacheManager();
        this.cache = remoteCacheManager.administration().getOrCreateCache("mycache", (BasicConfiguration)stringConfiguration);
        RemoteInfinispanCacheMeterBinderProvider remoteInfinispanCacheMeterBinderProvider = new RemoteInfinispanCacheMeterBinderProvider();
        return (CacheMeterBinder)remoteInfinispanCacheMeterBinderProvider.getMeterBinder((Cache)new SpringCache(this.cache), Collections.emptyList());
    }

    public void put(String key, String value) {
        this.cache.put((Object)key, (Object)value);
    }

    public String get(String key) {
        return (String)this.cache.get((Object)key);
    }
}

