/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.starter.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.spring.starter.remote.InfinispanRemoteCacheCustomizer;
import org.infinispan.spring.starter.remote.InfinispanRemoteCacheManagerChecker;
import org.infinispan.spring.starter.remote.InfinispanRemoteConfigurationProperties;
import org.infinispan.spring.starter.remote.InfinispanRemoteConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

@org.springframework.context.annotation.Configuration
@ComponentScan
@AutoConfigureBefore(value={CacheAutoConfiguration.class})
@ConditionalOnClass(name={"org.infinispan.client.hotrod.RemoteCacheManager"})
@ConditionalOnProperty(value={"infinispan.remote.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={InfinispanRemoteConfigurationProperties.class})
public class InfinispanRemoteAutoConfiguration {
    @Autowired
    private InfinispanRemoteConfigurationProperties infinispanProperties;
    @Autowired(required=false)
    private InfinispanRemoteConfigurer infinispanRemoteConfigurer;
    @Autowired(required=false)
    private Configuration infinispanConfiguration;
    @Autowired(required=false)
    private List<InfinispanRemoteCacheCustomizer> cacheCustomizers = Collections.emptyList();
    @Autowired
    private ApplicationContext ctx;

    @Bean
    @Conditional(value={InfinispanRemoteCacheManagerChecker.class})
    @ConditionalOnMissingBean
    public RemoteCacheManager remoteCacheManager() throws IOException {
        Configuration configuration;
        boolean hasHotRodPropertiesFile = this.ctx.getResource(this.infinispanProperties.getClientProperties()).exists();
        boolean hasConfigurer = this.infinispanRemoteConfigurer != null;
        boolean hasProperties = StringUtils.hasText((String)this.infinispanProperties.getServerList());
        if (hasConfigurer) {
            configuration = this.infinispanRemoteConfigurer.getRemoteConfiguration();
            Objects.nonNull(configuration);
            ConfigurationBuilder builder = new ConfigurationBuilder().read(configuration);
            this.cacheCustomizers.forEach(c -> c.customize(builder));
            configuration = builder.build();
        } else if (hasHotRodPropertiesFile) {
            String remoteClientPropertiesLocation = this.infinispanProperties.getClientProperties();
            Resource hotRodClientPropertiesFile = this.ctx.getResource(remoteClientPropertiesLocation);
            Properties hotrodClientProperties = new Properties();
            try (InputStream stream = hotRodClientPropertiesFile.getURL().openStream();){
                hotrodClientProperties.load(stream);
                ConfigurationBuilder builder = new ConfigurationBuilder().withProperties(hotrodClientProperties);
                this.cacheCustomizers.forEach(c -> c.customize(builder));
                configuration = builder.build();
            }
        } else if (hasProperties) {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.addServers(this.infinispanProperties.getServerList());
            Optional.ofNullable(this.infinispanProperties.getConnectTimeout()).map(v -> builder.connectionTimeout(v.intValue()));
            Optional.ofNullable(this.infinispanProperties.getMaxRetries()).map(v -> builder.maxRetries(v.intValue()));
            Optional.ofNullable(this.infinispanProperties.getSocketTimeout()).map(v -> builder.socketTimeout(v.intValue()));
            this.cacheCustomizers.forEach(c -> c.customize(builder));
            configuration = builder.build();
        } else if (this.infinispanConfiguration != null) {
            ConfigurationBuilder builder = new ConfigurationBuilder().read(this.infinispanConfiguration);
            this.cacheCustomizers.forEach(c -> c.customize(builder));
            configuration = builder.build();
        } else {
            throw new IllegalStateException("Not enough data to create RemoteCacheManager. Check InfinispanRemoteCacheManagerCheckerand update conditions.");
        }
        return new RemoteCacheManager(configuration);
    }
}

