/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.starter.remote;

import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.spring.starter.remote.InfinispanRemoteConfigurer;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.autoconfigure.cache.CacheType;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class InfinispanRemoteCacheManagerChecker
implements Condition {
    public boolean matches(ConditionContext ctx, AnnotatedTypeMetadata atm) {
        return this.checkCacheType(ctx) && (this.hasConfigurer(ctx) || this.hasHotRodClientPropertiesFile(ctx) || this.hasServersProperty(ctx) || this.hasConfiguration(ctx));
    }

    private boolean checkCacheType(ConditionContext context) {
        String cacheType = context.getEnvironment().getProperty("spring.cache.type");
        return cacheType == null || CacheType.INFINISPAN.name().equalsIgnoreCase(cacheType);
    }

    private boolean hasServersProperty(ConditionContext conditionContext) {
        return conditionContext.getEnvironment().getProperty("infinispan.remote.server-list") != null;
    }

    private boolean hasConfigurer(ConditionContext conditionContext) {
        try {
            conditionContext.getBeanFactory().getBean(InfinispanRemoteConfigurer.class);
            return true;
        }
        catch (NoSuchBeanDefinitionException e) {
            return false;
        }
    }

    private boolean hasConfiguration(ConditionContext conditionContext) {
        try {
            conditionContext.getBeanFactory().getBean(Configuration.class);
            return true;
        }
        catch (NoSuchBeanDefinitionException e) {
            return false;
        }
    }

    private boolean hasHotRodClientPropertiesFile(ConditionContext conditionContext) {
        String hotRodPropertiesPath = conditionContext.getEnvironment().getProperty("infinispan.remote.client-properties");
        if (hotRodPropertiesPath == null) {
            hotRodPropertiesPath = "classpath:hotrod-client.properties";
        }
        return conditionContext.getResourceLoader().getResource(hotRodPropertiesPath).exists();
    }
}

