/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import java.util.Collection;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.spring.provider.SpringCache;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.util.Assert;

public class SpringRemoteCacheManager
implements CacheManager {
    private final RemoteCacheManager nativeCacheManager;

    public SpringRemoteCacheManager(RemoteCacheManager nativeCacheManager) {
        Assert.notNull((Object)nativeCacheManager, (String)"A non-null instance of EmbeddedCacheManager needs to be supplied");
        this.nativeCacheManager = nativeCacheManager;
    }

    public <K, V> Cache<K, V> getCache(String name) {
        return new SpringCache(this.nativeCacheManager.getCache(name));
    }

    public Collection<String> getCacheNames() {
        throw new UnsupportedOperationException("Operation getCacheNames() is currently not supported.");
    }

    public RemoteCacheManager getNativeCacheManager() {
        return this.nativeCacheManager;
    }

    public void start() {
        this.nativeCacheManager.start();
    }

    public void stop() {
        this.nativeCacheManager.stop();
    }
}

