/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support.remote;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class HotrodServerLifecycleBean
implements InitializingBean,
DisposableBean {
    private EmbeddedCacheManager cacheManager;
    private RemoteCacheManager remoteCacheManager;
    private HotRodServer hotrodServer;
    private String remoteCacheName;

    public void setRemoteCacheName(String remoteCacheName) {
        this.remoteCacheName = remoteCacheName;
    }

    public void afterPropertiesSet() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager();
        this.cacheManager.getCache(this.remoteCacheName);
        this.hotrodServer = TestHelper.startHotRodServer((EmbeddedCacheManager)this.cacheManager);
        this.remoteCacheManager = new RemoteCacheManager("localhost", this.hotrodServer.getPort());
    }

    public void destroy() throws Exception {
        this.remoteCacheManager.stop();
        this.hotrodServer.stop();
        this.cacheManager.stop();
    }
}

