/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.support.embedded.InfinispanNamedEmbeddedCacheFactoryBean;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SpringCacheCacheTest", groups={"unit"})
public class SpringCacheCacheTest {
    protected static final String CACHE_NAME = "testCache";
    private final InfinispanNamedEmbeddedCacheFactoryBean<Object, Object> fb = new InfinispanNamedEmbeddedCacheFactoryBean();
    private Cache<Object, Object> nativeCache;
    private org.springframework.cache.Cache<Object, Object> cache;

    @BeforeMethod
    public void setUp() throws Exception {
        this.nativeCache = this.createNativeCache();
        this.cache = this.createCache(this.nativeCache);
        this.cache.clear();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.nativeCache = null;
        this.cache.clear();
        this.cache = null;
        this.fb.destroy();
    }

    @Test
    public void testCacheName() throws Exception {
        AssertJUnit.assertEquals((String)CACHE_NAME, (String)this.cache.getName());
    }

    @Test
    public void testNativeCache() throws Exception {
        AssertJUnit.assertSame(this.nativeCache, (Object)this.cache.getNativeCache());
    }

    @Test
    public void testCachePut() throws Exception {
        String key = "enescu";
        String value = "george";
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
        this.cache.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key));
    }

    @Test
    public void testCacheContains() throws Exception {
        String key = "enescu";
        String value = "george";
        this.cache.put((Object)key, (Object)value);
        AssertJUnit.assertTrue((boolean)this.cache.containsKey((Object)key));
    }

    @Test
    public void testCacheRemove() throws Exception {
        String key = "enescu";
        String value = "george";
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
        this.cache.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.remove((Object)key));
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
    }

    @Test
    public void testCacheClear() throws Exception {
        AssertJUnit.assertNull((Object)this.cache.get((Object)"enescu"));
        this.cache.put((Object)"enescu", (Object)"george");
        AssertJUnit.assertNull((Object)this.cache.get((Object)"vlaicu"));
        this.cache.put((Object)"vlaicu", (Object)"aurel");
        this.cache.clear();
        AssertJUnit.assertNull((Object)this.cache.get((Object)"vlaicu"));
        AssertJUnit.assertNull((Object)this.cache.get((Object)"enescu"));
    }

    @Test
    public void testPutIfAbsent() throws Exception {
        String key = "enescu";
        String value1 = "george";
        String value2 = "geo";
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
        this.cache.put((Object)key, (Object)value1);
        this.cache.putIfAbsent((Object)key, (Object)value2);
        AssertJUnit.assertEquals((Object)value1, (Object)this.cache.get((Object)key));
    }

    @Test
    public void testConcurrentRemove() throws Exception {
        String key = "enescu";
        String value1 = "george";
        String value2 = "geo";
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
        this.cache.put((Object)key, (Object)value1);
        this.cache.remove((Object)key, (Object)value2);
        AssertJUnit.assertEquals((Object)value1, (Object)this.cache.get((Object)key));
        this.cache.remove((Object)key, (Object)value1);
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
    }

    @Test
    public void testConcurrentReplace() throws Exception {
        String key = "enescu";
        String value1 = "george";
        String value2 = "geo";
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
        this.cache.put((Object)key, (Object)value1);
        this.cache.replace((Object)key, (Object)value2);
        AssertJUnit.assertEquals((Object)value2, (Object)this.cache.get((Object)key));
        this.cache.remove((Object)key);
        this.cache.replace((Object)key, (Object)value1);
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
    }

    @Test
    public void testConcurrentReplaceIfEqual() throws Exception {
        String key = "enescu";
        String value1 = "george";
        String value2 = "geo";
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
        this.cache.put((Object)key, (Object)value1);
        AssertJUnit.assertEquals((Object)value1, (Object)this.cache.get((Object)key));
        this.cache.replace((Object)key, (Object)value2, (Object)value1);
        AssertJUnit.assertEquals((Object)value1, (Object)this.cache.get((Object)key));
        this.cache.replace((Object)key, (Object)value1, (Object)value2);
        AssertJUnit.assertEquals((Object)value2, (Object)this.cache.get((Object)key));
        this.cache.replace((Object)key, (Object)value2, (Object)value1);
        AssertJUnit.assertEquals((Object)value1, (Object)this.cache.get((Object)key));
    }

    private Cache<Object, Object> createNativeCache() throws Exception {
        this.fb.setInfinispanEmbeddedCacheManager((EmbeddedCacheManager)new DefaultCacheManager());
        this.fb.setBeanName(CACHE_NAME);
        this.fb.setCacheName(CACHE_NAME);
        this.fb.afterPropertiesSet();
        return this.fb.getObject();
    }

    private org.springframework.cache.Cache<Object, Object> createCache(Cache<Object, Object> nativeCache) {
        return new SpringCache(nativeCache);
    }
}

