/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support.embedded;

import org.infinispan.manager.EmbeddedCacheManager;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
@ContextConfiguration(value={"classpath:/org/infinispan/spring/support/embedded/InfinispanEmbeddedCacheManagerFactoryBeanContextTest.xml"})
@Test(testName="spring.support.embedded.", groups={"functional"})
public class InfinispanEmbeddedCacheManagerFactoryBeanContextTest
extends AbstractTestNGSpringContextTests {
    private static final String INFINISPAN_EMBEDDED_CACHE_MANAGER_WITH_DEFAULT_CONFIGURATION_BEAN_NAME = "infinispanEmbeddedCacheManagerWithDefaultConfiguration";
    private static final String INFINISPAN_EMBEDDED_CACHE_MANAGER_CONFIGURED_FROM_CONFIGURATION_FILE_BEAN_NAME = "infinispanEmbeddedCacheManagerConfiguredFromConfigurationFile";
    private static final String INFINISPAN_EMBEDDED_CACHE_MANAGER_CONFIGURED_USING_SETTERS_BEAN_NAME = "infinispanEmbeddedCacheManagerConfiguredUsingSetters";

    @Test
    public final void shouldCreateAnEmbeddedCacheManagerWithDefaultSettingsIfNoFurtherConfigurationGiven() {
        EmbeddedCacheManager infinispanEmbeddedCacheManagerWithDefaultConfiguration = (EmbeddedCacheManager)this.applicationContext.getBean(INFINISPAN_EMBEDDED_CACHE_MANAGER_WITH_DEFAULT_CONFIGURATION_BEAN_NAME, EmbeddedCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a EmbeddedCacheManager with default settings having bean name = \"infinispanEmbeddedCacheManagerWithDefaultConfiguration\". However, it doesn't.", (Object)infinispanEmbeddedCacheManagerWithDefaultConfiguration);
    }

    @Test
    public final void shouldCreateAnEmbeddedCacheManagerConfiguredFromConfigurationFileIfConfigurationFileLocationGiven() {
        EmbeddedCacheManager infinispanEmbeddedCacheManagerConfiguredFromConfigurationFile = (EmbeddedCacheManager)this.applicationContext.getBean(INFINISPAN_EMBEDDED_CACHE_MANAGER_CONFIGURED_FROM_CONFIGURATION_FILE_BEAN_NAME, EmbeddedCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a EmbeddedCacheManager configured from configuration file having bean name = \"infinispanEmbeddedCacheManagerConfiguredFromConfigurationFile\". However, it doesn't.", (Object)infinispanEmbeddedCacheManagerConfiguredFromConfigurationFile);
    }

    @Test
    public final void shouldCreateAnEmbeddedCacheManagerConfiguredUsingSettersIfPropertiesAreDefined() {
        EmbeddedCacheManager infinispanEmbeddedCacheManagerConfiguredUsingSetters = (EmbeddedCacheManager)this.applicationContext.getBean(INFINISPAN_EMBEDDED_CACHE_MANAGER_CONFIGURED_USING_SETTERS_BEAN_NAME, EmbeddedCacheManager.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a EmbeddedCacheManager configured using properties having bean name = \"infinispanEmbeddedCacheManagerConfiguredUsingSetters\". However, it doesn't.", (Object)infinispanEmbeddedCacheManagerConfiguredUsingSetters);
    }
}

