/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support.remote;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.spring.support.remote.InfinispanNamedRemoteCacheFactoryBean;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="spring.support.remote.InfinispanNamedRemoteCacheFactoryBeanTest", groups={"functional"})
public class InfinispanNamedRemoteCacheFactoryBeanTest
extends SingleCacheManagerTest {
    private static final String TEST_BEAN_NAME = "test.bean.Name";
    private static final String TEST_CACHE_NAME = "test.cache.Name";
    private RemoteCacheManager remoteCacheManager;
    private HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager();
        this.cache = this.cacheManager.getCache(TEST_CACHE_NAME);
        this.cache = this.cacheManager.getCache(TEST_BEAN_NAME);
        return this.cacheManager;
    }

    @BeforeClass
    public void setupRemoteCacheFactory() {
        this.hotrodServer = TestHelper.startHotRodServer((EmbeddedCacheManager)this.cacheManager);
        this.remoteCacheManager = new RemoteCacheManager("localhost", this.hotrodServer.getPort());
    }

    @AfterClass
    public void destroyRemoteCacheFactory() {
        this.remoteCacheManager.stop();
        this.hotrodServer.stop();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public final void infinispanNamedRemoteCacheFactoryBeanShouldRecognizeThatNoCacheContainerHasBeenSet() throws Exception {
        InfinispanNamedRemoteCacheFactoryBean objectUnderTest = new InfinispanNamedRemoteCacheFactoryBean();
        objectUnderTest.setCacheName(TEST_CACHE_NAME);
        objectUnderTest.setBeanName(TEST_BEAN_NAME);
        objectUnderTest.afterPropertiesSet();
    }

    @Test
    public final void infinispanNamedRemoteCacheFactoryBeanShouldUseBeanNameAsCacheNameIfNoCacheNameHasBeenSet() throws Exception {
        String beanName = TEST_BEAN_NAME;
        InfinispanNamedRemoteCacheFactoryBean objectUnderTest = new InfinispanNamedRemoteCacheFactoryBean();
        objectUnderTest.setInfinispanRemoteCacheManager(this.remoteCacheManager);
        objectUnderTest.setBeanName(TEST_BEAN_NAME);
        objectUnderTest.afterPropertiesSet();
        Cache cache = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"InfinispanNamedRemoteCacheFactoryBean should have used its bean name [test.bean.Name] as the name of the created cache. However, it didn't.", (String)TEST_BEAN_NAME, (String)cache.getName());
    }

    @Test
    public final void infinispanNamedRemoteCacheFactoryBeanShouldPreferExplicitCacheNameToBeanName() throws Exception {
        InfinispanNamedRemoteCacheFactoryBean objectUnderTest = new InfinispanNamedRemoteCacheFactoryBean();
        objectUnderTest.setInfinispanRemoteCacheManager(this.remoteCacheManager);
        objectUnderTest.setCacheName(TEST_CACHE_NAME);
        objectUnderTest.setBeanName(TEST_BEAN_NAME);
        objectUnderTest.afterPropertiesSet();
        Cache cache = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"InfinispanNamedRemoteCacheFactoryBean should have preferred its cache name [test.cache.Name] as the name of the created cache. However, it didn't.", (String)TEST_CACHE_NAME, (String)cache.getName());
    }

    @Test
    public final void infinispanNamedRemoteCacheFactoryBeanShouldReportTheMostDerivedObjectType() throws Exception {
        InfinispanNamedRemoteCacheFactoryBean objectUnderTest = new InfinispanNamedRemoteCacheFactoryBean();
        objectUnderTest.setInfinispanRemoteCacheManager(this.remoteCacheManager);
        objectUnderTest.setBeanName(TEST_BEAN_NAME);
        objectUnderTest.afterPropertiesSet();
        AssertJUnit.assertEquals((String)"getObjectType() should have returned the most derived class of the actual Cache implementation returned from getObject(). However, it didn't.", objectUnderTest.getObject().getClass(), (Object)objectUnderTest.getObjectType());
    }

    @Test
    public final void infinispanNamedRemoteCacheFactoryBeanShouldProduceANonNullInfinispanCache() throws Exception {
        InfinispanNamedRemoteCacheFactoryBean objectUnderTest = new InfinispanNamedRemoteCacheFactoryBean();
        objectUnderTest.setInfinispanRemoteCacheManager(this.remoteCacheManager);
        objectUnderTest.setCacheName(TEST_CACHE_NAME);
        objectUnderTest.setBeanName(TEST_BEAN_NAME);
        objectUnderTest.afterPropertiesSet();
        Cache cache = objectUnderTest.getObject();
        AssertJUnit.assertNotNull((String)"InfinispanNamedRemoteCacheFactoryBean should have produced a proper Infinispan cache. However, it produced a null Infinispan cache.", (Object)cache);
    }

    @Test
    public final void infinispanNamedRemoteCacheFactoryBeanShouldDeclareItselfToBeSingleton() {
        InfinispanNamedRemoteCacheFactoryBean objectUnderTest = new InfinispanNamedRemoteCacheFactoryBean();
        AssertJUnit.assertTrue((String)"InfinispanNamedRemoteCacheFactoryBean should declare itself to produce a singleton. However, it didn't.", (boolean)objectUnderTest.isSingleton());
    }
}

