/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support;

import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.spring.support.InfinispanDefaultCacheFactoryBean;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="spring.support.InfinispanDefaultCacheFactoryBeanTest", groups={"unit"})
public class InfinispanDefaultCacheFactoryBeanTest {
    @Test(expectedExceptions={IllegalStateException.class})
    public final void afterPropertiesSetShouldThrowAnIllegalStateExceptionIfNoCacheContainerHasBeenSet() throws Exception {
        InfinispanDefaultCacheFactoryBean objectUnderTest = new InfinispanDefaultCacheFactoryBean();
        objectUnderTest.afterPropertiesSet();
    }

    @Test
    public final void infinispanDefaultCacheFactoryBeanShouldProduceANonNullInfinispanCache() throws Exception {
        InfinispanDefaultCacheFactoryBean objectUnderTest = new InfinispanDefaultCacheFactoryBean();
        objectUnderTest.setInfinispanCacheContainer((CacheContainer)new DefaultCacheManager());
        objectUnderTest.afterPropertiesSet();
        Cache cache = objectUnderTest.getObject();
        AssertJUnit.assertNotNull((String)"InfinispanDefaultCacheFactoryBean should have produced a proper Infinispan cache. However, it produced a null Infinispan cache.", (Object)cache);
        objectUnderTest.destroy();
    }

    @Test
    public final void getObjectTypeShouldReturnTheMostDerivedTypeOfTheProducedInfinispanCache() throws Exception {
        InfinispanDefaultCacheFactoryBean objectUnderTest = new InfinispanDefaultCacheFactoryBean();
        objectUnderTest.setInfinispanCacheContainer((CacheContainer)new DefaultCacheManager());
        objectUnderTest.afterPropertiesSet();
        AssertJUnit.assertEquals((String)"getObjectType() should have returned the produced Infinispan cache's most derived type. However, it returned a more generic type.", objectUnderTest.getObject().getClass(), (Object)objectUnderTest.getObjectType());
        objectUnderTest.destroy();
    }

    @Test
    public final void infinispanDefaultCacheFactoryBeanShouldDeclareItselfToBeSingleton() {
        InfinispanDefaultCacheFactoryBean objectUnderTest = new InfinispanDefaultCacheFactoryBean();
        AssertJUnit.assertTrue((String)"InfinispanDefaultCacheFactoryBean should declare itself to produce a singleton. However, it didn't.", (boolean)objectUnderTest.isSingleton());
    }

    @Test
    public final void infinispanDefaultCacheFactoryBeanShouldStopTheCreatedInfinispanCacheWhenItIsDestroyed() throws Exception {
        InfinispanDefaultCacheFactoryBean objectUnderTest = new InfinispanDefaultCacheFactoryBean();
        objectUnderTest.setInfinispanCacheContainer((CacheContainer)new DefaultCacheManager());
        objectUnderTest.afterPropertiesSet();
        Cache cache = objectUnderTest.getObject();
        objectUnderTest.destroy();
        AssertJUnit.assertEquals((String)"InfinispanDefaultCacheFactoryBean should have stopped the created Infinispan cache when being destroyed. However, the created Infinispan is not yet terminated.", (Object)ComponentStatus.TERMINATED, (Object)cache.getStatus());
    }
}

