/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.support.embedded.InfinispanNamedEmbeddedCacheFactoryBean;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SpringCacheCacheTest", groups={"unit"})
public class SpringCacheCacheTest {
    protected static final String CACHE_NAME = "testCache";
    private final InfinispanNamedEmbeddedCacheFactoryBean<Object, Object> fb = new InfinispanNamedEmbeddedCacheFactoryBean();
    private Cache<Object, Object> nativeCache;
    private org.springframework.cache.Cache cache;

    @BeforeMethod
    public void setUp() throws Exception {
        this.nativeCache = this.createNativeCache();
        this.cache = this.createCache(this.nativeCache);
        this.cache.clear();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.nativeCache = null;
        this.cache.clear();
        this.cache = null;
        this.fb.destroy();
    }

    @Test
    public void testCacheName() throws Exception {
        AssertJUnit.assertEquals((String)CACHE_NAME, (String)this.cache.getName());
    }

    @Test
    public void testNativeCache() throws Exception {
        AssertJUnit.assertSame(this.nativeCache, (Object)this.cache.getNativeCache());
    }

    @Test
    public void testCachePut() throws Exception {
        String key = "enescu";
        String value = "george";
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
        this.cache.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key).get());
    }

    @Test
    public void testCacheContains() throws Exception {
        String key = "enescu";
        String value = "george";
        this.cache.put((Object)key, (Object)value);
        AssertJUnit.assertTrue((this.cache.get((Object)key) != null ? 1 : 0) != 0);
    }

    @Test
    public void testCacheClear() throws Exception {
        AssertJUnit.assertNull((Object)this.cache.get((Object)"enescu"));
        this.cache.put((Object)"enescu", (Object)"george");
        AssertJUnit.assertNull((Object)this.cache.get((Object)"vlaicu"));
        this.cache.put((Object)"vlaicu", (Object)"aurel");
        this.cache.clear();
        AssertJUnit.assertNull((Object)this.cache.get((Object)"vlaicu"));
        AssertJUnit.assertNull((Object)this.cache.get((Object)"enescu"));
    }

    private Cache<Object, Object> createNativeCache() throws Exception {
        this.fb.setInfinispanEmbeddedCacheManager((EmbeddedCacheManager)new DefaultCacheManager());
        this.fb.setBeanName(CACHE_NAME);
        this.fb.setCacheName(CACHE_NAME);
        this.fb.afterPropertiesSet();
        return this.fb.getObject();
    }

    private org.springframework.cache.Cache createCache(Cache<Object, Object> nativeCache) {
        return new SpringCache(nativeCache);
    }
}

