/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support.embedded;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.ConfigurationOverrides;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class InfinispanNamedEmbeddedCacheFactoryBean<K, V>
implements FactoryBean<Cache<K, V>>,
BeanNameAware,
InitializingBean,
DisposableBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private EmbeddedCacheManager infinispanEmbeddedCacheManager;
    private ConfigurationTemplateMode configurationTemplateMode = ConfigurationTemplateMode.NAMED;
    private String cacheName;
    private String beanName;
    private final ConfigurationOverrides configurationOverrides = new ConfigurationOverrides();
    private Cache<K, V> infinispanCache;

    public void afterPropertiesSet() throws Exception {
        if (this.infinispanEmbeddedCacheManager == null) {
            throw new IllegalStateException("No Infinispan EmbeddedCacheManager has been set");
        }
        this.logger.info((Object)"Initializing named Infinispan embedded cache ...");
        String effectiveCacheName = this.obtainEffectiveCacheName();
        this.infinispanCache = this.configureAndCreateNamedCache(effectiveCacheName);
        this.logger.info((Object)("New Infinispan embedded cache [" + this.infinispanCache + "] initialized"));
    }

    private Cache<K, V> configureAndCreateNamedCache(String cacheName) {
        switch (this.configurationTemplateMode) {
            case NONE: {
                this.logger.debug((Object)"ConfigurationTemplateMode is NONE: starting with a fresh Configuration");
                if (this.infinispanEmbeddedCacheManager.getCacheNames().contains(cacheName)) {
                    throw new IllegalStateException("Cannot use ConfigurationTemplateMode NONE: a cache named [" + cacheName + "] has already been defined.");
                }
                Configuration newConfiguration = new Configuration();
                Configuration customizedNewConfiguration = this.infinispanEmbeddedCacheManager.defineConfiguration(cacheName, newConfiguration);
                this.configurationOverrides.applyOverridesTo(customizedNewConfiguration);
                break;
            }
            case NAMED: {
                this.logger.debug((Object)("ConfigurationTemplateMode is NAMED: starting with a named Configuration [" + cacheName + "]"));
                Configuration namedConfiguration = new Configuration();
                Configuration customizedNamedConfiguration = this.infinispanEmbeddedCacheManager.defineConfiguration(cacheName, cacheName, namedConfiguration);
                this.configurationOverrides.applyOverridesTo(customizedNamedConfiguration);
                break;
            }
            case DEFAULT: {
                this.logger.debug((Object)"ConfigurationTemplateMode is DEFAULT: starting with default Configuration");
                if (this.infinispanEmbeddedCacheManager.getCacheNames().contains(cacheName)) {
                    throw new IllegalStateException("Cannot use ConfigurationTemplateMode DEFAULT: a cache named [" + cacheName + "] has already been defined.");
                }
                Configuration defaultConfiguration = this.infinispanEmbeddedCacheManager.getDefaultConfiguration().clone();
                Configuration customizedDefaultConfiguration = this.infinispanEmbeddedCacheManager.defineConfiguration(cacheName, defaultConfiguration);
                this.configurationOverrides.applyOverridesTo(customizedDefaultConfiguration);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ConfigurationTemplateMode: " + (Object)((Object)this.configurationTemplateMode));
            }
        }
        return this.infinispanEmbeddedCacheManager.getCache(cacheName);
    }

    private String obtainEffectiveCacheName() {
        if (StringUtils.hasText((String)this.cacheName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using custom cache name [" + this.cacheName + "]"));
            }
            return this.cacheName;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using bean name [" + this.beanName + "] as cache name"));
        }
        return this.beanName;
    }

    public Cache<K, V> getObject() throws Exception {
        return this.infinispanCache;
    }

    public Class<? extends Cache> getObjectType() {
        return this.infinispanCache != null ? this.infinispanCache.getClass() : Cache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void destroy() throws Exception {
        if (this.infinispanCache != null) {
            this.infinispanCache.stop();
        }
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setInfinispanEmbeddedCacheManager(EmbeddedCacheManager infinispanEmbeddedCacheManager) {
        this.infinispanEmbeddedCacheManager = infinispanEmbeddedCacheManager;
    }

    public void setConfigurationTemplateMode(String configurationTemplateMode) throws IllegalArgumentException {
        this.configurationTemplateMode = ConfigurationTemplateMode.valueOf(configurationTemplateMode);
    }

    public void setDeadlockDetectionSpinDuration(Long eagerDeadlockSpinDuration) {
        this.configurationOverrides.setDeadlockDetectionSpinDuration(eagerDeadlockSpinDuration);
    }

    public void setEnableDeadlockDetection(Boolean useEagerDeadlockDetection) {
        this.configurationOverrides.setEnableDeadlockDetection(useEagerDeadlockDetection);
    }

    public void setUseLockStriping(Boolean useLockStriping) {
        this.configurationOverrides.setUseLockStriping(useLockStriping);
    }

    public void setUnsafeUnreliableReturnValues(Boolean unsafeUnreliableReturnValues) {
        this.configurationOverrides.setUnsafeUnreliableReturnValues(unsafeUnreliableReturnValues);
    }

    public void setRehashRpcTimeout(Long rehashRpcTimeout) {
        this.configurationOverrides.setRehashRpcTimeout(rehashRpcTimeout);
    }

    public void setWriteSkewCheck(Boolean writeSkewCheck) {
        this.configurationOverrides.setWriteSkewCheck(writeSkewCheck);
    }

    public void setConcurrencyLevel(Integer concurrencyLevel) {
        this.configurationOverrides.setConcurrencyLevel(concurrencyLevel);
    }

    public void setReplQueueMaxElements(Integer replQueueMaxElements) {
        this.configurationOverrides.setReplQueueMaxElements(replQueueMaxElements);
    }

    public void setReplQueueInterval(Long replQueueInterval) {
        this.configurationOverrides.setReplQueueInterval(replQueueInterval);
    }

    public void setReplQueueClass(String replQueueClass) {
        this.configurationOverrides.setReplQueueClass(replQueueClass);
    }

    public void setExposeJmxStatistics(Boolean exposeJmxStatistics) {
        this.configurationOverrides.setExposeJmxStatistics(exposeJmxStatistics);
    }

    public void setInvocationBatchingEnabled(Boolean invocationBatchingEnabled) {
        this.configurationOverrides.setInvocationBatchingEnabled(invocationBatchingEnabled);
    }

    public void setFetchInMemoryState(Boolean fetchInMemoryState) {
        this.configurationOverrides.setFetchInMemoryState(fetchInMemoryState);
    }

    public void setAlwaysProvideInMemoryState(Boolean alwaysProvideInMemoryState) {
        this.configurationOverrides.setAlwaysProvideInMemoryState(alwaysProvideInMemoryState);
    }

    public void setLockAcquisitionTimeout(Long lockAcquisitionTimeout) {
        this.configurationOverrides.setLockAcquisitionTimeout(lockAcquisitionTimeout);
    }

    public void setSyncReplTimeout(Long syncReplTimeout) {
        this.configurationOverrides.setSyncReplTimeout(syncReplTimeout);
    }

    public void setCacheModeString(String cacheModeString) {
        this.configurationOverrides.setCacheModeString(cacheModeString);
    }

    public void setExpirationWakeUpInterval(Long expirationWakeUpInterval) {
        this.configurationOverrides.setExpirationWakeUpInterval(expirationWakeUpInterval);
    }

    public void setEvictionStrategy(EvictionStrategy evictionStrategy) {
        this.configurationOverrides.setEvictionStrategy(evictionStrategy);
    }

    public void setEvictionStrategyClass(String evictionStrategyClass) {
        this.configurationOverrides.setEvictionStrategyClass(evictionStrategyClass);
    }

    public void setEvictionThreadPolicy(EvictionThreadPolicy evictionThreadPolicy) {
        this.configurationOverrides.setEvictionThreadPolicy(evictionThreadPolicy);
    }

    public void setEvictionThreadPolicyClass(String evictionThreadPolicyClass) {
        this.configurationOverrides.setEvictionThreadPolicyClass(evictionThreadPolicyClass);
    }

    public void setEvictionMaxEntries(Integer evictionMaxEntries) {
        this.configurationOverrides.setEvictionMaxEntries(evictionMaxEntries);
    }

    public void setExpirationLifespan(Long expirationLifespan) {
        this.configurationOverrides.setExpirationLifespan(expirationLifespan);
    }

    public void setExpirationMaxIdle(Long expirationMaxIdle) {
        this.configurationOverrides.setExpirationMaxIdle(expirationMaxIdle);
    }

    public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
        this.configurationOverrides.setTransactionManagerLookupClass(transactionManagerLookupClass);
    }

    public void setTransactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.configurationOverrides.setTransactionManagerLookup(transactionManagerLookup);
    }

    public void setCacheLoaderManagerConfig(CacheLoaderManagerConfig cacheLoaderManagerConfig) {
        this.configurationOverrides.setCacheLoaderManagerConfig(cacheLoaderManagerConfig);
    }

    public void setSyncCommitPhase(Boolean syncCommitPhase) {
        this.configurationOverrides.setSyncCommitPhase(syncCommitPhase);
    }

    public void setSyncRollbackPhase(Boolean syncRollbackPhase) {
        this.configurationOverrides.setSyncRollbackPhase(syncRollbackPhase);
    }

    public void setUseEagerLocking(Boolean useEagerLocking) {
        this.configurationOverrides.setUseEagerLocking(useEagerLocking);
    }

    public void setEagerLockSingleNode(Boolean eagerLockSingleNode) {
        this.configurationOverrides.setEagerLockSingleNode(eagerLockSingleNode);
    }

    public void setUseReplQueue(Boolean useReplQueue) {
        this.configurationOverrides.setUseReplQueue(useReplQueue);
    }

    public void setIsolationLevel(IsolationLevel isolationLevel) {
        this.configurationOverrides.setIsolationLevel(isolationLevel);
    }

    public void setStateRetrievalTimeout(Long stateRetrievalTimeout) {
        this.configurationOverrides.setStateRetrievalTimeout(stateRetrievalTimeout);
    }

    public void setStateRetrievalLogFlushTimeout(Long stateRetrievalLogFlushTimeout) {
        this.configurationOverrides.setStateRetrievalLogFlushTimeout(stateRetrievalLogFlushTimeout);
    }

    public void setStateRetrievalMaxNonProgressingLogWrites(Integer stateRetrievalMaxNonProgressingLogWrites) {
        this.configurationOverrides.setStateRetrievalMaxNonProgressingLogWrites(stateRetrievalMaxNonProgressingLogWrites);
    }

    public void setStateRetrievalInitialRetryWaitTime(Long stateRetrievalInitialRetryWaitTime) {
        this.configurationOverrides.setStateRetrievalInitialRetryWaitTime(stateRetrievalInitialRetryWaitTime);
    }

    public void setStateRetrievalRetryWaitTimeIncreaseFactor(Integer stateRetrievalRetryWaitTimeIncreaseFactor) {
        this.configurationOverrides.setStateRetrievalRetryWaitTimeIncreaseFactor(stateRetrievalRetryWaitTimeIncreaseFactor);
    }

    public void setStateRetrievalNumRetries(Integer stateRetrievalNumRetries) {
        this.configurationOverrides.setStateRetrievalNumRetries(stateRetrievalNumRetries);
    }

    public void setIsolationLevelClass(String isolationLevelClass) {
        this.configurationOverrides.setIsolationLevelClass(isolationLevelClass);
    }

    public void setUseLazyDeserialization(Boolean useLazyDeserialization) {
        this.configurationOverrides.setUseLazyDeserialization(useLazyDeserialization);
    }

    public void setL1CacheEnabled(Boolean l1CacheEnabled) {
        this.configurationOverrides.setL1CacheEnabled(l1CacheEnabled);
    }

    public void setL1Lifespan(Long l1Lifespan) {
        this.configurationOverrides.setL1Lifespan(l1Lifespan);
    }

    public void setL1OnRehash(Boolean l1OnRehash) {
        this.configurationOverrides.setL1OnRehash(l1OnRehash);
    }

    public void setConsistentHashClass(String consistentHashClass) {
        this.configurationOverrides.setConsistentHashClass(consistentHashClass);
    }

    public void setNumOwners(Integer numOwners) {
        this.configurationOverrides.setNumOwners(numOwners);
    }

    public void setRehashEnabled(Boolean rehashEnabled) {
        this.configurationOverrides.setRehashEnabled(rehashEnabled);
    }

    public void setRehashWaitTime(Long rehashWaitTime) {
        this.configurationOverrides.setRehashWaitTime(rehashWaitTime);
    }

    public void setUseAsyncMarshalling(Boolean useAsyncMarshalling) {
        this.configurationOverrides.setUseAsyncMarshalling(useAsyncMarshalling);
    }

    public void setIndexingEnabled(Boolean indexingEnabled) {
        this.configurationOverrides.setIndexingEnabled(indexingEnabled);
    }

    public void setIndexLocalOnly(Boolean indexLocalOnly) {
        this.configurationOverrides.setIndexLocalOnly(indexLocalOnly);
    }

    public void setCustomInterceptors(List<CustomInterceptorConfig> customInterceptors) {
        this.configurationOverrides.setCustomInterceptors(customInterceptors);
    }

    static enum ConfigurationTemplateMode {
        NONE,
        DEFAULT,
        NAMED;

    }
}

