/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring;

import java.util.Arrays;
import java.util.List;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.spring.ConfigurationOverrides;
import org.infinispan.transaction.lookup.JBossTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class ConfigurationOverridesTest {
    @Test
    public final void configurationOverridesShouldOverrideDeadlockSpinDetectionDurationPropIfExplicitlySet() throws Exception {
        long expectedDeadlockSpinDetectionDuration = 100000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setDeadlockDetectionSpinDuration(Long.valueOf(100000L));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set deadlockDetectionSpinDuration. However, it didn't.", (long)100000L, (long)defaultConfiguration.getDeadlockDetectionSpinDuration());
    }

    @Test
    public final void configurationOverridesShouldOverrideEnableDeadlockDetectionPropIfExplicitlySet() throws Exception {
        boolean expectedEnableDeadlockDetection = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setEnableDeadlockDetection(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set enableDeadlockDetection property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isDeadlockDetectionEnabled());
    }

    @Test
    public final void configurationOverridesShouldOverrideUseLockStripingPropIfExplicitlySet() throws Exception {
        boolean expectedUseLockStriping = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setUseLockStriping(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set useLockStriping property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isUseLockStriping());
    }

    @Test
    public final void configurationOverridesShouldOverrideUnsafeUnreliableReturnValuesPropIfExplicitlySet() throws Exception {
        boolean expectedUnsafeUnreliableReturnValues = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setUnsafeUnreliableReturnValues(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set unsafeUnreliableReturnValues property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isUnsafeUnreliableReturnValues());
    }

    @Test
    public final void configurationOverridesShouldOverrideRehashRpcTimeoutPropIfExplicitlySet() throws Exception {
        long expectedRehashRpcTimeout = 100000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setRehashRpcTimeout(Long.valueOf(100000L));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set rehashRpcTimeout property. However, it didn't.", (long)100000L, (long)defaultConfiguration.getRehashRpcTimeout());
    }

    @Test
    public final void configurationOverridesShouldOverrideWriteSkewCheckPropIfExplicitlySet() throws Exception {
        boolean expectedWriteSkewCheck = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setWriteSkewCheck(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set writeSkewCheck property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isWriteSkewCheck());
    }

    @Test
    public final void configurationOverridesShouldOverrideConcurrencyLevelPropIfExplicitlySet() throws Exception {
        int expectedConcurrencyLevel = 10000;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setConcurrencyLevel(Integer.valueOf(10000));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ConcurrencyLevel property. However, it didn't.", (int)10000, (int)defaultConfiguration.getConcurrencyLevel());
    }

    @Test
    public final void configurationOverridesShouldOverrideReplQueueMaxElementsPropIfExplicitlySet() throws Exception {
        int expectedReplQueueMaxElements = 10000;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setReplQueueMaxElements(Integer.valueOf(10000));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ReplQueueMaxElements property. However, it didn't.", (int)10000, (int)defaultConfiguration.getReplQueueMaxElements());
    }

    @Test
    public final void configurationOverridesShouldOverrideReplQueueIntervalPropIfExplicitlySet() throws Exception {
        long expectedReplQueueInterval = 10000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setReplQueueInterval(Long.valueOf(10000L));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ReplQueueInterval property. However, it didn't.", (long)10000L, (long)defaultConfiguration.getReplQueueInterval());
    }

    @Test
    public final void configurationOverridesShouldOverrideReplQueueClassPropIfExplicitlySet() throws Exception {
        String expectedReplQueueClass = "repl.queue.Class";
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setReplQueueClass("repl.queue.Class");
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ReplQueueClass property. However, it didn't.", (String)"repl.queue.Class", (String)defaultConfiguration.getReplQueueClass());
    }

    @Test
    public final void configurationOverridesShouldOverrideExposeJmxStatisticsPropIfExplicitlySet() throws Exception {
        boolean expectedExposeJmxStatistics = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setExposeJmxStatistics(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ExposeJmxStatistics property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isExposeJmxStatistics());
    }

    @Test
    public final void configurationOverridesShouldOverrideInvocationBatchingEnabledPropIfExplicitlySet() throws Exception {
        boolean expectedInvocationBatchingEnabled = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setInvocationBatchingEnabled(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set InvocationBatchingEnabled property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isInvocationBatchingEnabled());
    }

    @Test
    public final void configurationOverridesShouldOverrideFetchInMemoryStatePropIfExplicitlySet() throws Exception {
        boolean expectedFetchInMemoryState = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setFetchInMemoryState(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set FetchInMemoryState property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isFetchInMemoryState());
    }

    @Test
    public final void configurationOverridesShouldOverrideAlwaysProvideInMemoryStatePropIfExplicitlySet() throws Exception {
        boolean expectedAlwaysProvideInMemoryState = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setAlwaysProvideInMemoryState(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set AlwaysProvideInMemoryState property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isAlwaysProvideInMemoryState());
    }

    @Test
    public final void configurationOverridesShouldOverrideLockAcquisitionTimeoutPropIfExplicitlySet() throws Exception {
        long expectedLockAcquisitionTimeout = 1000000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setLockAcquisitionTimeout(Long.valueOf(1000000L));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set LockAcquisitionTimeout property. However, it didn't.", (long)1000000L, (long)defaultConfiguration.getLockAcquisitionTimeout());
    }

    @Test
    public final void configurationOverridesShouldOverrideSyncReplTimeoutPropIfExplicitlySet() throws Exception {
        long expectedSyncReplTimeout = 100000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setSyncReplTimeout(Long.valueOf(100000L));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set SyncReplTimeout property. However, it didn't.", (long)100000L, (long)defaultConfiguration.getSyncReplTimeout());
    }

    @Test
    public final void configurationOverridesShouldOverrideCacheModeStringPropIfExplicitlySet() throws Exception {
        String expectedCacheModeString = Configuration.CacheMode.LOCAL.name();
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setCacheModeString(expectedCacheModeString);
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set CacheModeString property. However, it didn't.", (String)expectedCacheModeString, (String)defaultConfiguration.getCacheModeString());
    }

    @Test
    public final void configurationOverridesShouldOverrideEvictionWakeUpIntervalPropIfExplicitlySet() throws Exception {
        long expectedExpirationWakeUpInterval = 100000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setExpirationWakeUpInterval(Long.valueOf(100000L));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set EvictionWakeUpInterval property. However, it didn't.", (long)100000L, (long)defaultConfiguration.getExpirationWakeUpInterval());
    }

    @Test
    public final void configurationOverridesShouldOverrideEvictionStrategyPropIfExplicitlySet() throws Exception {
        EvictionStrategy expectedEvictionStrategy = EvictionStrategy.LIRS;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setEvictionStrategy(expectedEvictionStrategy);
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set EvictionStrategy property. However, it didn't.", (Object)expectedEvictionStrategy, (Object)defaultConfiguration.getEvictionStrategy());
    }

    @Test
    public final void configurationOverridesShouldOverrideEvictionStrategyClassPropIfExplicitlySet() throws Exception {
        String expectedEvictionStrategyClass = "FIFO";
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setEvictionStrategyClass("FIFO");
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set EvictionStrategyClass property. However, it didn't.", (Object)EvictionStrategy.FIFO, (Object)defaultConfiguration.getEvictionStrategy());
    }

    @Test
    public final void configurationOverridesShouldOverrideEvictionThreadPolicyPropIfExplicitlySet() throws Exception {
        EvictionThreadPolicy expectedEvictionThreadPolicy = EvictionThreadPolicy.PIGGYBACK;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setEvictionThreadPolicy(expectedEvictionThreadPolicy);
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set EvictionThreadPolicy property. However, it didn't.", (Object)expectedEvictionThreadPolicy, (Object)defaultConfiguration.getEvictionThreadPolicy());
    }

    @Test
    public final void configurationOverridesShouldOverrideEvictionThreadPolicyClassPropIfExplicitlySet() throws Exception {
        String expectedEvictionThreadPolicyClass = "PIGGYBACK";
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setEvictionThreadPolicyClass("PIGGYBACK");
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set EvictionThreadPolicyClass property. However, it didn't.", (Object)EvictionThreadPolicy.PIGGYBACK, (Object)defaultConfiguration.getEvictionThreadPolicy());
    }

    @Test
    public final void configurationOverridesShouldOverrideEvictionMaxEntriesPropIfExplicitlySet() throws Exception {
        int expectedEvictionMaxEntries = 1000000;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setEvictionMaxEntries(Integer.valueOf(1000000));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set EvictionMaxEntries property. However, it didn't.", (int)1000000, (int)defaultConfiguration.getEvictionMaxEntries());
    }

    @Test
    public final void configurationOverridesShouldOverrideExpirationLifespanPropIfExplicitlySet() throws Exception {
        long expectedExpirationLifespan = 1000000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setExpirationLifespan(Long.valueOf(1000000L));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ExpirationLifespan property. However, it didn't.", (long)1000000L, (long)defaultConfiguration.getExpirationLifespan());
    }

    @Test
    public final void configurationOverridesShouldOverrideExpirationMaxIdlePropIfExplicitlySet() throws Exception {
        long expectedExpirationMaxIdle = 100000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setExpirationMaxIdle(Long.valueOf(100000L));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ExpirationMaxIdle property. However, it didn't.", (long)100000L, (long)defaultConfiguration.getExpirationMaxIdle());
    }

    @Test
    public final void configurationOverridesShouldOverrideTransactionManagerLookupClassPropIfExplicitlySet() throws Exception {
        String expectedTransactionManagerLookupClass = "expected.transaction.manager.lookup.Class";
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setTransactionManagerLookupClass("expected.transaction.manager.lookup.Class");
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set TransactionManagerLookupClass property. However, it didn't.", (String)"expected.transaction.manager.lookup.Class", (String)defaultConfiguration.getTransactionManagerLookupClass());
    }

    @Test
    public final void configurationOverridesShouldOverrideTransactionManagerLookupPropIfExplicitlySet() throws Exception {
        JBossTransactionManagerLookup expectedTransactionManagerLookup = new JBossTransactionManagerLookup();
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setTransactionManagerLookup((TransactionManagerLookup)expectedTransactionManagerLookup);
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set TransactionManagerLookup property. However, it didn't.", (Object)expectedTransactionManagerLookup, (Object)defaultConfiguration.getTransactionManagerLookup());
    }

    @Test
    public final void configurationOverridesShouldOverrideCacheLoaderManagerConfigPropIfExplicitlySet() throws Exception {
        CacheLoaderManagerConfig expectedCacheLoaderManagerConfig = new CacheLoaderManagerConfig();
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setCacheLoaderManagerConfig(expectedCacheLoaderManagerConfig);
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertSame((String)"ConfigurationOverrides should have overridden default value with explicitly set CacheLoaderManagerConfig property. However, it didn't.", (Object)expectedCacheLoaderManagerConfig, (Object)defaultConfiguration.getCacheLoaderManagerConfig());
    }

    @Test
    public final void configurationOverridesShouldOverrideSyncCommitPhasePropIfExplicitlySet() throws Exception {
        boolean expectedSyncCommitPhase = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setSyncCommitPhase(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set SyncCommitPhase property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isSyncCommitPhase());
    }

    @Test
    public final void configurationOverridesShouldOverrideSyncRollbackPhasePropIfExplicitlySet() throws Exception {
        boolean expectedSyncRollbackPhase = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setSyncRollbackPhase(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set SyncRollbackPhase property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isSyncRollbackPhase());
    }

    @Test
    public final void configurationOverridesShouldOverrideUseEagerLockingPropIfExplicitlySet() throws Exception {
        boolean expectedUseEagerLocking = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setUseEagerLocking(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set UseEagerLocking property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isUseEagerLocking());
    }

    @Test
    public final void configurationOverridesShouldOverrideEagerLockSingleNodePropIfExplicitlySet() throws Exception {
        boolean expectedEagerLockSingleNode = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setEagerLockSingleNode(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set EagerLockSingleNode property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isEagerLockSingleNode());
    }

    @Test
    public final void configurationOverridesShouldOverrideUseReplQueuePropIfExplicitlySet() throws Exception {
        boolean expectedUseReplQueue = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setUseReplQueue(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set UseReplQueue property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isUseReplQueue());
    }

    @Test
    public final void configurationOverridesShouldOverrideIsolationLevelPropIfExplicitlySet() throws Exception {
        IsolationLevel expectedIsolationLevel = IsolationLevel.SERIALIZABLE;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setIsolationLevel(expectedIsolationLevel);
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set IsolationLevel property. However, it didn't.", (Object)expectedIsolationLevel, (Object)defaultConfiguration.getIsolationLevel());
    }

    @Test
    public final void configurationOverridesShouldOverrideStateRetrievalTimeoutPropIfExplicitlySet() throws Exception {
        long expectedStateRetrievalTimeout = 1000000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setStateRetrievalTimeout(Long.valueOf(1000000L));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set StateRetrievalTimeout property. However, it didn't.", (long)1000000L, (long)defaultConfiguration.getStateRetrievalTimeout());
    }

    @Test
    public final void configurationOverridesShouldOverrideStateRetrievalLogFlushTimeoutPropIfExplicitlySet() throws Exception {
        long expectedStateRetrievalLogFlushTimeout = 1000000L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setStateRetrievalLogFlushTimeout(Long.valueOf(1000000L));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set StateRetrievalLogFlushTimeout property. However, it didn't.", (long)1000000L, (long)defaultConfiguration.getStateRetrievalLogFlushTimeout());
    }

    @Test
    public final void configurationOverridesShouldOverrideStateRetrievalMaxNonProgressingLogWritesPropIfExplicitlySet() throws Exception {
        int expectedStateRetrievalMaxNonProgressingLogWrites = 123456;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setStateRetrievalMaxNonProgressingLogWrites(Integer.valueOf(123456));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set StateRetrievalMaxNonProgressingLogWrites property. However, it didn't.", (int)123456, (int)defaultConfiguration.getStateRetrievalMaxNonProgressingLogWrites());
    }

    @Test
    public final void configurationOverridesShouldOverrideStateRetrievalInitialRetryWaitTimePropIfExplicitlySet() throws Exception {
        long expectedStateRetrievalInitialRetryWaitTime = 987665L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setStateRetrievalInitialRetryWaitTime(Long.valueOf(987665L));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set StateRetrievalInitialRetryWaitTime property. However, it didn't.", (long)987665L, (long)defaultConfiguration.getStateRetrievalInitialRetryWaitTime());
    }

    @Test
    public final void configurationOverridesShouldOverrideStateRetrievalRetryWaitTimeIncreaseFactorPropIfExplicitlySet() throws Exception {
        int expectedStateRetrievalRetryWaitTimeIncreaseFactor = 987432;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setStateRetrievalRetryWaitTimeIncreaseFactor(Integer.valueOf(987432));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set StateRetrievalRetryWaitTimeIncreaseFactor property. However, it didn't.", (int)987432, (int)defaultConfiguration.getStateRetrievalRetryWaitTimeIncreaseFactor());
    }

    @Test
    public final void configurationOverridesShouldOverrideStateRetrievalNumRetriesPropIfExplicitlySet() throws Exception {
        int expectedStateRetrievalNumRetries = 765123;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setStateRetrievalNumRetries(Integer.valueOf(765123));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set StateRetrievalNumRetries property. However, it didn't.", (int)765123, (int)defaultConfiguration.getStateRetrievalNumRetries());
    }

    @Test
    public final void configurationOverridesShouldOverrideIsolationLevelClassPropIfExplicitlySet() throws Exception {
        String expectedIsolationLevelClass = "REPEATABLE_READ";
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setIsolationLevelClass("REPEATABLE_READ");
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set IsolationLevelClass property. However, it didn't.", (Object)IsolationLevel.REPEATABLE_READ, (Object)defaultConfiguration.getIsolationLevel());
    }

    @Test
    public final void configurationOverridesShouldOverrideUseLazyDeserializationPropIfExplicitlySet() throws Exception {
        boolean expectedUseLazyDeserialization = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setUseLazyDeserialization(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set UseLazyDeserialization property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isStoreAsBinary());
    }

    @Test
    public final void configurationOverridesShouldOverrideL1CacheEnabledPropIfExplicitlySet() throws Exception {
        boolean expectedL1CacheEnabled = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setL1CacheEnabled(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set L1CacheEnabled property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isL1CacheEnabled());
    }

    @Test
    public final void configurationOverridesShouldOverrideL1LifespanPropIfExplicitlySet() throws Exception {
        long expectedL1Lifespan = 2300446L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setL1Lifespan(Long.valueOf(2300446L));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set L1Lifespan property. However, it didn't.", (long)2300446L, (long)defaultConfiguration.getL1Lifespan());
    }

    @Test
    public final void configurationOverridesShouldOverrideL1OnRehashPropIfExplicitlySet() throws Exception {
        boolean expectedL1OnRehash = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setL1OnRehash(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set L1OnRehash property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isL1OnRehash());
    }

    @Test
    public final void configurationOverridesShouldOverrideConsistentHashClassPropIfExplicitlySet() throws Exception {
        String expectedConsistentHashClass = "expected.consistent.hash.Class";
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setConsistentHashClass("expected.consistent.hash.Class");
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set ConsistentHashClass property. However, it didn't.", (String)"expected.consistent.hash.Class", (String)defaultConfiguration.getConsistentHashClass());
    }

    @Test
    public final void configurationOverridesShouldOverrideNumOwnersPropIfExplicitlySet() throws Exception {
        int expectedNumOwners = 675443;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setNumOwners(Integer.valueOf(675443));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set NumOwners property. However, it didn't.", (int)675443, (int)defaultConfiguration.getNumOwners());
    }

    @Test
    public final void configurationOverridesShouldOverrideRehashEnabledPropIfExplicitlySet() throws Exception {
        boolean expectedRehashEnabled = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setRehashEnabled(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set RehashEnabled property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isRehashEnabled());
    }

    @Test
    public final void configurationOverridesShouldOverrideRehashWaitTimePropIfExplicitlySet() throws Exception {
        long expectedRehashWaitTime = 1232778L;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setRehashWaitTime(Long.valueOf(1232778L));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set RehashWaitTime property. However, it didn't.", (long)1232778L, (long)defaultConfiguration.getRehashWaitTime());
    }

    @Test
    public final void configurationOverridesShouldOverrideUseAsyncMarshallingPropIfExplicitlySet() throws Exception {
        boolean expectedUseAsyncMarshalling = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setUseAsyncMarshalling(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set UseAsyncMarshalling property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isUseAsyncMarshalling());
    }

    @Test
    public final void configurationOverridesShouldOverrideIndexingEnabledPropIfExplicitlySet() throws Exception {
        boolean expectedIndexingEnabled = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setIndexingEnabled(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set IndexingEnabled property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isIndexingEnabled());
    }

    @Test
    public final void configurationOverridesShouldOverrideIndexLocalOnlyPropIfExplicitlySet() throws Exception {
        boolean expectedIndexLocalOnly = true;
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setIndexLocalOnly(Boolean.valueOf(true));
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set IndexLocalOnly property. However, it didn't.", (boolean)true, (boolean)defaultConfiguration.isIndexLocalOnly());
    }

    @Test
    public final void configurationOverridesShouldOverrideCustomInterceptorsPropIfExplicitlySet() throws Exception {
        CustomInterceptorConfig customInterceptor = new CustomInterceptorConfig();
        List<CustomInterceptorConfig> expectedCustomInterceptors = Arrays.asList(customInterceptor);
        ConfigurationOverrides objectUnderTest = new ConfigurationOverrides();
        objectUnderTest.setCustomInterceptors(expectedCustomInterceptors);
        Configuration defaultConfiguration = new Configuration();
        objectUnderTest.applyOverridesTo(defaultConfiguration);
        AssertJUnit.assertEquals((String)"ConfigurationOverrides should have overridden default value with explicitly set CustomInterceptors property. However, it didn't.", expectedCustomInterceptors, (Object)defaultConfiguration.getCustomInterceptors());
    }
}

