/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import java.util.Properties;
import javax.management.MBeanServer;
import org.infinispan.Cache;
import org.infinispan.Version;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PlatformMBeanServerLookup;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.spring.mock.MockExecutorFatory;
import org.infinispan.spring.mock.MockMarshaller;
import org.infinispan.spring.mock.MockScheduleExecutorFactory;
import org.infinispan.spring.mock.MockTransport;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.provider.SpringEmbeddedCacheManager;
import org.infinispan.spring.provider.SpringEmbeddedCacheManagerFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SpringEmbeddedCacheManagerFactoryBeanTest", groups={"unit"})
public class SpringEmbeddedCacheManagerFactoryBeanTest {
    private static final String CACHE_NAME_FROM_CONFIGURATION_FILE = "asyncCache";
    private static final String NAMED_ASYNC_CACHE_CONFIG_LOCATION = "named-async-cache.xml";

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldCreateACacheManagerEvenIfNoDefaultConfigurationLocationHasBeenSet() throws Exception {
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertNotNull((String)"getObject() should have returned a valid SpringEmbeddedCacheManager, even if no defaulConfigurationLocation has been specified. However, it returned null.", (Object)springEmbeddedCacheManager);
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldCreateACustomizedCacheManagerIfGivenADefaultConfigurationLocation() throws Exception {
        ClassPathResource infinispanConfig = new ClassPathResource(NAMED_ASYNC_CACHE_CONFIG_LOCATION, this.getClass());
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setConfigurationFileLocation((Resource)infinispanConfig);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertNotNull((String)"getObject() should have returned a valid SpringEmbeddedCacheManager, configured using the configuration file set on SpringEmbeddedCacheManagerFactoryBean. However, it returned null.", (Object)springEmbeddedCacheManager);
        SpringCache cacheDefinedInCustomConfiguration = springEmbeddedCacheManager.getCache(CACHE_NAME_FROM_CONFIGURATION_FILE);
        Configuration configuration = ((Cache)cacheDefinedInCustomConfiguration.getNativeCache()).getConfiguration();
        AssertJUnit.assertEquals((String)"The cache named [asyncCache] is configured to have asynchonous replication cache mode. Yet, the cache returned from getCache(asyncCache) has a different cache mode. Obviously, SpringEmbeddedCacheManagerFactoryBean did not use the configuration file when instantiating SpringEmbeddedCacheManager.", (Object)Configuration.CacheMode.REPL_ASYNC, (Object)configuration.getCacheMode());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldReportTheCorrectObjectType() throws Exception {
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"getObjectType() should return the most derived class of the actual SpringEmbeddedCacheManager implementation returned from getObject(). However, it didn't.", springEmbeddedCacheManager.getClass(), (Object)objectUnderTest.getObjectType());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldDeclareItselfToOnlyProduceSingletons() {
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        AssertJUnit.assertTrue((String)"isSingleton() should always return true. However, it returned false", (boolean)objectUnderTest.isSingleton());
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldStopTheCreateEmbeddedCacheManagerWhenBeingDestroyed() throws Exception {
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        springEmbeddedCacheManager.getCache("default");
        objectUnderTest.destroy();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should stop the created SpringEmbeddedCacheManager when being destroyed. However, the created SpringEmbeddedCacheManager is still not terminated.", (Object)ComponentStatus.TERMINATED, (Object)springEmbeddedCacheManager.getNativeCacheManager().getStatus());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseExposeGlobalJmxStatisticsPropIfExplicitlySet() throws Exception {
        boolean expectedExposeGlobalJmxStatistics = true;
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setExposeGlobalJmxStatistics(true);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ExposeGlobalJmxStatistics. However, it didn't.", (boolean)true, (boolean)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().isExposeGlobalJmxStatistics());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseJmxDomainPropIfExplicitlySet() throws Exception {
        String expectedJmxDomain = "expected.jmx.Domain";
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setJmxDomain("expected.jmx.Domain");
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set JmxDomain. However, it didn't.", (String)"expected.jmx.Domain", (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getJmxDomain());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseMBeanServerPropertiesPropIfExplicitlySet() throws Exception {
        Properties expectedMBeanServerProperties = new Properties();
        expectedMBeanServerProperties.setProperty("key", "value");
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMBeanServerProperties(expectedMBeanServerProperties);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MBeanServerProperties. However, it didn't.", (Object)expectedMBeanServerProperties, (Object)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getMBeanServerProperties());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseMBeanServerLookupClassPropIfExplicitlySet() throws Exception {
        MBeanServerLookup expectedMBeanServerLookup = new MBeanServerLookup(){

            public MBeanServer getMBeanServer(Properties properties) {
                return null;
            }
        };
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMBeanServerLookupClass(expectedMBeanServerLookup.getClass().getName());
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MBeanServerLookupClass. However, it didn't.", (String)expectedMBeanServerLookup.getClass().getName(), (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getMBeanServerLookup());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseMBeanServerLookupPropIfExplicitlySet() throws Exception {
        PlatformMBeanServerLookup expectedMBeanServerLookup = new PlatformMBeanServerLookup();
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMBeanServerLookup((MBeanServerLookup)expectedMBeanServerLookup);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertSame((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MBeanServerLookup. However, it didn't.", (Object)expectedMBeanServerLookup.getClass().getName(), (Object)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getMBeanServerLookup());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseAllowDuplicateDomainsPropIfExplicitlySet() throws Exception {
        boolean expectedAllowDuplicateDomains = true;
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAllowDuplicateDomains(true);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AllowDuplicateDomains. However, it didn't.", (boolean)true, (boolean)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().isAllowDuplicateDomains());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseCacheManagerNamePropIfExplicitlySet() throws Exception {
        String expectedCacheManagerName = "expected.cache.manager.Name";
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setCacheManagerName("expected.cache.manager.Name");
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set CacheManagerName. However, it didn't.", (String)"expected.cache.manager.Name", (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getCacheManagerName());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseStrictPeerToPeerPropIfExplicitlySet() throws Exception {
        boolean expectedStrictPeerToPeer = true;
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setStrictPeerToPeer(true);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set StrictPeerToPeer. However, it didn't.", (boolean)true, (boolean)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().isStrictPeerToPeer());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseAsyncListenerExecutorFactoryClassPropIfExplicitlySet() throws Exception {
        String expectedAsyncListenerExecutorFactoryClass = MockExecutorFatory.class.getName();
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAsyncListenerExecutorFactoryClass(expectedAsyncListenerExecutorFactoryClass);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AsyncListenerExecutorFactoryClass. However, it didn't.", (String)expectedAsyncListenerExecutorFactoryClass, (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getAsyncListenerExecutorFactoryClass());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseAsyncTransportExecutorFactoryClassPropIfExplicitlySet() throws Exception {
        String expectedAsyncTransportExecutorFactoryClass = MockExecutorFatory.class.getName();
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAsyncTransportExecutorFactoryClass(expectedAsyncTransportExecutorFactoryClass);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AsyncTransportExecutorFactoryClass. However, it didn't.", (String)expectedAsyncTransportExecutorFactoryClass, (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getAsyncTransportExecutorFactoryClass());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseEvictionScheduledExecutorFactoryClassPropIfExplicitlySet() throws Exception {
        String expectedEvictionScheduledExecutorFactoryClass = MockScheduleExecutorFactory.class.getName();
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setEvictionScheduledExecutorFactoryClass(expectedEvictionScheduledExecutorFactoryClass);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set EvictionScheduledExecutorFactoryClass. However, it didn't.", (String)expectedEvictionScheduledExecutorFactoryClass, (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getEvictionScheduledExecutorFactoryClass());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseReplicationQueueScheduledExecutorFactoryClassPropIfExplicitlySet() throws Exception {
        String expectedReplicationQueueScheduledExecutorFactoryClass = MockExecutorFatory.class.getName();
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setReplicationQueueScheduledExecutorFactoryClass(expectedReplicationQueueScheduledExecutorFactoryClass);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ReplicationQueueScheduledExecutorFactoryClass. However, it didn't.", (String)expectedReplicationQueueScheduledExecutorFactoryClass, (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getReplicationQueueScheduledExecutorFactoryClass());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseMarshallerClassPropIfExplicitlySet() throws Exception {
        String expectedMarshallerClass = MockMarshaller.class.getName();
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMarshallerClass(expectedMarshallerClass);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MarshallerClass. However, it didn't.", (String)expectedMarshallerClass, (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getMarshallerClass());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseTransportNodeNamePropIfExplicitlySet() throws Exception {
        String expectedTransportNodeName = "expected.transport.node.Name";
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setTransportNodeName("expected.transport.node.Name");
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set TransportNodeName. However, it didn't.", (String)"expected.transport.node.Name", (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getTransportNodeName());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseTransportClassPropIfExplicitlySet() throws Exception {
        String expectedTransportClass = MockTransport.class.getName();
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setTransportClass(expectedTransportClass);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set TransportClass. However, it didn't.", (String)expectedTransportClass, (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getTransportClass());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseTransportPropertiesPropIfExplicitlySet() throws Exception {
        Properties expectedTransportProperties = new Properties();
        expectedTransportProperties.setProperty("key", "value");
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setTransportProperties(expectedTransportProperties);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set TransportProperties. However, it didn't.", (Object)expectedTransportProperties, (Object)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getTransportProperties());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseClusterNamePropIfExplicitlySet() throws Exception {
        String expectedClusterName = "expected.cluster.Name";
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setClusterName("expected.cluster.Name");
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ClusterName. However, it didn't.", (String)"expected.cluster.Name", (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getClusterName());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseMachineIdPropIfExplicitlySet() throws Exception {
        String expectedMachineId = "expected.machine.Id";
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMachineId("expected.machine.Id");
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MachineId. However, it didn't.", (String)"expected.machine.Id", (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getMachineId());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseRackIdPropIfExplicitlySet() throws Exception {
        String expectedRackId = "expected.rack.Id";
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setRackId("expected.rack.Id");
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set RackId. However, it didn't.", (String)"expected.rack.Id", (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getRackId());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseSiteIdPropIfExplicitlySet() throws Exception {
        String expectedSiteId = "expected.site.Id";
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setSiteId("expected.site.Id");
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set SiteId. However, it didn't.", (String)"expected.site.Id", (String)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getSiteId());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseShutdownHookBehaviorPropIfExplicitlySet() throws Exception {
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setShutdownHookBehavior(GlobalConfiguration.ShutdownHookBehavior.DONT_REGISTER.name());
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ShutdownHookBehavior. However, it didn't.", (Object)GlobalConfiguration.ShutdownHookBehavior.DONT_REGISTER, (Object)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getShutdownHookBehavior());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseAsyncListenerExecutorPropertiesPropIfExplicitlySet() throws Exception {
        Properties expectedAsyncListenerExecutorProperties = new Properties();
        expectedAsyncListenerExecutorProperties.setProperty("key", "value");
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAsyncListenerExecutorProperties(expectedAsyncListenerExecutorProperties);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AsyncListenerExecutorProperties. However, it didn't.", (Object)expectedAsyncListenerExecutorProperties, (Object)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getAsyncListenerExecutorProperties());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseAsyncTransportExecutorPropertiesPropIfExplicitlySet() throws Exception {
        Properties expectedAsyncTransportExecutorProperties = new Properties();
        expectedAsyncTransportExecutorProperties.setProperty("key", "value");
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAsyncTransportExecutorProperties(expectedAsyncTransportExecutorProperties);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AsyncTransportExecutorProperties. However, it didn't.", (Object)expectedAsyncTransportExecutorProperties, (Object)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getAsyncTransportExecutorProperties());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseEvictionScheduledExecutorPropertiesPropIfExplicitlySet() throws Exception {
        Properties expectedEvictionScheduledExecutorProperties = new Properties();
        expectedEvictionScheduledExecutorProperties.setProperty("key", "value");
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setEvictionScheduledExecutorProperties(expectedEvictionScheduledExecutorProperties);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set EvictionScheduledExecutorProperties. However, it didn't.", (Object)expectedEvictionScheduledExecutorProperties, (Object)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getEvictionScheduledExecutorProperties());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseReplicationQueueScheduledExecutorPropertiesPropIfExplicitlySet() throws Exception {
        Properties expectedReplicationQueueScheduledExecutorProperties = new Properties();
        expectedReplicationQueueScheduledExecutorProperties.setProperty("key", "value");
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setReplicationQueueScheduledExecutorProperties(expectedReplicationQueueScheduledExecutorProperties);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ReplicationQueueScheduledExecutorProperties. However, it didn't.", (Object)expectedReplicationQueueScheduledExecutorProperties, (Object)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getReplicationQueueScheduledExecutorProperties());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseMarshallVersionPropIfExplicitlySet() throws Exception {
        int setMarshallVersion = 1234;
        short expectedMarshallVersion = Version.getVersionShort((String)Version.decodeVersionForSerialization((short)1234));
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMarshallVersion((short)1234);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MarshallVersion. However, it didn't.", (short)expectedMarshallVersion, (short)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getMarshallVersion());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldUseDistributedSyncTimeoutPropIfExplicitlySet() throws Exception {
        long expectedDistributedSyncTimeout = 123456L;
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setDistributedSyncTimeout(123456L);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set DistributedSyncTimeout. However, it didn't.", (long)123456L, (long)springEmbeddedCacheManager.getNativeCacheManager().getGlobalConfiguration().getDistributedSyncTimeout());
        springEmbeddedCacheManager.stop();
    }
}

