/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import java.io.IOException;
import java.util.Collection;
import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.provider.SpringEmbeddedCacheManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SpringEmbeddedCacheManagerTest", groups={"unit"})
public class SpringEmbeddedCacheManagerTest {
    private static final String CACHE_NAME_FROM_CONFIGURATION_FILE = "asyncCache";
    private static final String NAMED_ASYNC_CACHE_CONFIG_LOCATION = "named-async-cache.xml";

    @Test(expectedExceptions={IllegalArgumentException.class})
    public final void springEmbeddedCacheManagerConstructorShouldRejectNullEmbeddedCacheManager() {
        new SpringEmbeddedCacheManager(null);
    }

    @Test
    public final void getCacheShouldReturnTheCacheHavingTheProvidedName() throws IOException {
        DefaultCacheManager nativeCacheManager = new DefaultCacheManager(SpringEmbeddedCacheManagerTest.class.getResourceAsStream(NAMED_ASYNC_CACHE_CONFIG_LOCATION));
        SpringEmbeddedCacheManager objectUnderTest = new SpringEmbeddedCacheManager((EmbeddedCacheManager)nativeCacheManager);
        SpringCache cacheExpectedToHaveTheProvidedName = objectUnderTest.getCache(CACHE_NAME_FROM_CONFIGURATION_FILE);
        AssertJUnit.assertEquals((String)"getCache(asyncCache) should have returned the cache having the provided name. However, the cache returned has a different name.", (String)CACHE_NAME_FROM_CONFIGURATION_FILE, (String)cacheExpectedToHaveTheProvidedName.getName());
        nativeCacheManager.stop();
    }

    @Test
    public final void getCacheShouldReturnACacheAddedAfterCreatingTheSpringEmbeddedCache() throws IOException {
        String nameOfInfinispanCacheAddedLater = "infinispan.cache.addedLater";
        DefaultCacheManager nativeCacheManager = new DefaultCacheManager(SpringEmbeddedCacheManagerTest.class.getResourceAsStream(NAMED_ASYNC_CACHE_CONFIG_LOCATION));
        SpringEmbeddedCacheManager objectUnderTest = new SpringEmbeddedCacheManager((EmbeddedCacheManager)nativeCacheManager);
        Cache infinispanCacheAddedLater = nativeCacheManager.getCache("infinispan.cache.addedLater");
        SpringCache springCacheAddedLater = objectUnderTest.getCache("infinispan.cache.addedLater");
        AssertJUnit.assertEquals((String)"getCache(infinispan.cache.addedLater) should have returned the Spring cache having the Infinispan cache added after creating SpringEmbeddedCacheManager as its underlying native cache. However, the underlying native cache is different.", (Object)infinispanCacheAddedLater, (Object)springCacheAddedLater.getNativeCache());
        nativeCacheManager.stop();
    }

    @Test
    public final void getCacheNamesShouldReturnAllCachesDefinedInConfigurationFile() throws IOException {
        DefaultCacheManager nativeCacheManager = new DefaultCacheManager(SpringEmbeddedCacheManagerTest.class.getResourceAsStream(NAMED_ASYNC_CACHE_CONFIG_LOCATION));
        SpringEmbeddedCacheManager objectUnderTest = new SpringEmbeddedCacheManager((EmbeddedCacheManager)nativeCacheManager);
        Collection cacheNames = objectUnderTest.getCacheNames();
        AssertJUnit.assertTrue((String)"SpringEmbeddedCacheManager should load all named caches found in the configuration file of the wrapped native cache manager. However, it does not know about the cache named asyncCache defined in said configuration file.", (boolean)cacheNames.contains(CACHE_NAME_FROM_CONFIGURATION_FILE));
        nativeCacheManager.stop();
    }

    @Test
    public final void stopShouldStopTheNativeEmbeddedCacheManager() throws IOException {
        DefaultCacheManager nativeCacheManager = new DefaultCacheManager();
        nativeCacheManager.getCache();
        SpringEmbeddedCacheManager objectUnderTest = new SpringEmbeddedCacheManager((EmbeddedCacheManager)nativeCacheManager);
        objectUnderTest.stop();
        AssertJUnit.assertEquals((String)"Calling stop() on SpringEmbeddedCacheManager should stop the enclosed Infinispan EmbeddedCacheManager. However, it is still running.", (Object)ComponentStatus.TERMINATED, (Object)nativeCacheManager.getStatus());
    }

    @Test
    public final void getNativeCacheShouldReturnTheEmbeddedCacheManagerSuppliedAtConstructionTime() throws IOException {
        DefaultCacheManager nativeCacheManager = new DefaultCacheManager();
        SpringEmbeddedCacheManager objectUnderTest = new SpringEmbeddedCacheManager((EmbeddedCacheManager)nativeCacheManager);
        EmbeddedCacheManager nativeCacheManagerReturned = objectUnderTest.getNativeCacheManager();
        AssertJUnit.assertSame((String)"getNativeCacheManager() should have returned the EmbeddedCacheManager supplied at construction time. However, it retuned a different one.", (Object)nativeCacheManager, (Object)nativeCacheManagerReturned);
        nativeCacheManager.stop();
    }
}

