/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support.embedded;

import java.util.Properties;
import javax.management.MBeanServer;
import org.infinispan.Cache;
import org.infinispan.Version;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PlatformMBeanServerLookup;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.mock.MockExecutorFatory;
import org.infinispan.spring.mock.MockTransport;
import org.infinispan.spring.support.embedded.InfinispanEmbeddedCacheManagerFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="spring.support.embedded.InfinispanEmbeddedCacheManagerFactoryBeanTest", groups={"unit"})
public class InfinispanEmbeddedCacheManagerFactoryBeanTest {
    private static final String CACHE_NAME_FROM_CONFIGURATION_FILE = "asyncCache";
    private static final String NAMED_ASYNC_CACHE_CONFIG_LOCATION = "named-async-cache.xml";

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldCreateACacheManagerEvenIfNoDefaultConfigurationLocationHasBeenSet() throws Exception {
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertNotNull((String)"getObject() should have returned a valid EmbeddedCacheManager, even if no defaulConfigurationLocation has been specified. However, it returned null.", (Object)embeddedCacheManager);
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldCreateACustomizedCacheManagerIfGivenADefaultConfigurationLocation() throws Exception {
        ClassPathResource infinispanConfig = new ClassPathResource(NAMED_ASYNC_CACHE_CONFIG_LOCATION, this.getClass());
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setConfigurationFileLocation((Resource)infinispanConfig);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertNotNull((String)"getObject() should have returned a valid EmbeddedCacheManager, configured using the configuration file set on SpringEmbeddedCacheManagerFactoryBean. However, it returned null.", (Object)embeddedCacheManager);
        Cache cacheDefinedInCustomConfiguration = embeddedCacheManager.getCache(CACHE_NAME_FROM_CONFIGURATION_FILE);
        Configuration configuration = cacheDefinedInCustomConfiguration.getConfiguration();
        AssertJUnit.assertEquals((String)"The cache named [asyncCache] is configured to have asynchonous replication cache mode. Yet, the cache returned from getCache(asyncCache) has a different cache mode. Obviously, SpringEmbeddedCacheManagerFactoryBean did not use the configuration file when instantiating EmbeddedCacheManager.", (Object)Configuration.CacheMode.REPL_ASYNC, (Object)configuration.getCacheMode());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldReportTheCorrectObjectType() throws Exception {
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"getObjectType() should return the most derived class of the actual EmbeddedCacheManager implementation returned from getObject(). However, it didn't.", embeddedCacheManager.getClass(), (Object)objectUnderTest.getObjectType());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldDeclareItselfToOnlyProduceSingletons() {
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        AssertJUnit.assertTrue((String)"isSingleton() should always return true. However, it returned false", (boolean)objectUnderTest.isSingleton());
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldStopTheCreateEmbeddedCacheManagerWhenBeingDestroyed() throws Exception {
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        embeddedCacheManager.getCache();
        objectUnderTest.destroy();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should stop the created EmbeddedCacheManager when being destroyed. However, the created EmbeddedCacheManager is still not terminated.", (Object)ComponentStatus.TERMINATED, (Object)embeddedCacheManager.getStatus());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseExposeGlobalJmxStatisticsPropIfExplicitlySet() throws Exception {
        boolean expectedExposeGlobalJmxStatistics = true;
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setExposeGlobalJmxStatistics(true);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ExposeGlobalJmxStatistics. However, it didn't.", (boolean)true, (boolean)embeddedCacheManager.getGlobalConfiguration().isExposeGlobalJmxStatistics());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseJmxDomainPropIfExplicitlySet() throws Exception {
        String expectedJmxDomain = "expected.jmx.Domain";
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setJmxDomain("expected.jmx.Domain");
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set JmxDomain. However, it didn't.", (String)"expected.jmx.Domain", (String)embeddedCacheManager.getGlobalConfiguration().getJmxDomain());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseMBeanServerPropertiesPropIfExplicitlySet() throws Exception {
        Properties expectedMBeanServerProperties = new Properties();
        expectedMBeanServerProperties.setProperty("key", "value");
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMBeanServerProperties(expectedMBeanServerProperties);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MBeanServerProperties. However, it didn't.", (Object)expectedMBeanServerProperties, (Object)embeddedCacheManager.getGlobalConfiguration().getMBeanServerProperties());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseMBeanServerLookupClassPropIfExplicitlySet() throws Exception {
        MBeanServerLookup expectedMBeanServerLookup = new MBeanServerLookup(){

            public MBeanServer getMBeanServer(Properties properties) {
                return null;
            }
        };
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMBeanServerLookupClass(expectedMBeanServerLookup.getClass().getName());
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MBeanServerLookupClass. However, it didn't.", (String)expectedMBeanServerLookup.getClass().getName(), (String)embeddedCacheManager.getGlobalConfiguration().getMBeanServerLookup());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseMBeanServerLookupPropIfExplicitlySet() throws Exception {
        PlatformMBeanServerLookup expectedMBeanServerLookup = new PlatformMBeanServerLookup();
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMBeanServerLookup((MBeanServerLookup)expectedMBeanServerLookup);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertSame((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MBeanServerLookup. However, it didn't.", (Object)expectedMBeanServerLookup.getClass().getName(), (Object)embeddedCacheManager.getGlobalConfiguration().getMBeanServerLookup());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseAllowDuplicateDomainsPropIfExplicitlySet() throws Exception {
        boolean expectedAllowDuplicateDomains = true;
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAllowDuplicateDomains(true);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AllowDuplicateDomains. However, it didn't.", (boolean)true, (boolean)embeddedCacheManager.getGlobalConfiguration().isAllowDuplicateDomains());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseCacheManagerNamePropIfExplicitlySet() throws Exception {
        String expectedCacheManagerName = "expected.cache.manager.Name";
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setCacheManagerName("expected.cache.manager.Name");
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set CacheManagerName. However, it didn't.", (String)"expected.cache.manager.Name", (String)embeddedCacheManager.getGlobalConfiguration().getCacheManagerName());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseStrictPeerToPeerPropIfExplicitlySet() throws Exception {
        boolean expectedStrictPeerToPeer = true;
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setStrictPeerToPeer(true);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set StrictPeerToPeer. However, it didn't.", (boolean)true, (boolean)embeddedCacheManager.getGlobalConfiguration().isStrictPeerToPeer());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseAsyncListenerExecutorFactoryClassPropIfExplicitlySet() throws Exception {
        String expectedAsyncListenerExecutorFactoryClass = MockExecutorFatory.class.getName();
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAsyncListenerExecutorFactoryClass(expectedAsyncListenerExecutorFactoryClass);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AsyncListenerExecutorFactoryClass. However, it didn't.", (String)expectedAsyncListenerExecutorFactoryClass, (String)embeddedCacheManager.getGlobalConfiguration().getAsyncListenerExecutorFactoryClass());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseAsyncTransportExecutorFactoryClassPropIfExplicitlySet() throws Exception {
        String expectedAsyncTransportExecutorFactoryClass = "expected.async.transport.executor.Factory";
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAsyncTransportExecutorFactoryClass("expected.async.transport.executor.Factory");
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AsyncTransportExecutorFactoryClass. However, it didn't.", (String)"expected.async.transport.executor.Factory", (String)embeddedCacheManager.getGlobalConfiguration().getAsyncTransportExecutorFactoryClass());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseEvictionScheduledExecutorFactoryClassPropIfExplicitlySet() throws Exception {
        String expectedEvictionScheduledExecutorFactoryClass = "expected.eviction.scheduler.Factory";
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setEvictionScheduledExecutorFactoryClass("expected.eviction.scheduler.Factory");
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set EvictionScheduledExecutorFactoryClass. However, it didn't.", (String)"expected.eviction.scheduler.Factory", (String)embeddedCacheManager.getGlobalConfiguration().getEvictionScheduledExecutorFactoryClass());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseReplicationQueueScheduledExecutorFactoryClassPropIfExplicitlySet() throws Exception {
        String expectedReplicationQueueScheduledExecutorFactoryClass = "expected.replication.queue.scheduled.executor.Factory";
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setReplicationQueueScheduledExecutorFactoryClass("expected.replication.queue.scheduled.executor.Factory");
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ReplicationQueueScheduledExecutorFactoryClass. However, it didn't.", (String)"expected.replication.queue.scheduled.executor.Factory", (String)embeddedCacheManager.getGlobalConfiguration().getReplicationQueueScheduledExecutorFactoryClass());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseMarshallerClassPropIfExplicitlySet() throws Exception {
        String expectedMarshallerClass = "expected.marshaller.Class";
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMarshallerClass("expected.marshaller.Class");
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MarshallerClass. However, it didn't.", (String)"expected.marshaller.Class", (String)embeddedCacheManager.getGlobalConfiguration().getMarshallerClass());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseTransportNodeNamePropIfExplicitlySet() throws Exception {
        String expectedTransportNodeName = "expected.transport.node.Name";
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setTransportNodeName("expected.transport.node.Name");
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set TransportNodeName. However, it didn't.", (String)"expected.transport.node.Name", (String)embeddedCacheManager.getGlobalConfiguration().getTransportNodeName());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseTransportClassPropIfExplicitlySet() throws Exception {
        String expectedTransportClass = MockTransport.class.getName();
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setTransportClass(expectedTransportClass);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set TransportClass. However, it didn't.", (String)expectedTransportClass, (String)embeddedCacheManager.getGlobalConfiguration().getTransportClass());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseTransportPropertiesPropIfExplicitlySet() throws Exception {
        Properties expectedTransportProperties = new Properties();
        expectedTransportProperties.setProperty("key", "value");
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setTransportProperties(expectedTransportProperties);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set TransportProperties. However, it didn't.", (Object)expectedTransportProperties, (Object)embeddedCacheManager.getGlobalConfiguration().getTransportProperties());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseClusterNamePropIfExplicitlySet() throws Exception {
        String expectedClusterName = "expected.cluster.Name";
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setClusterName("expected.cluster.Name");
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ClusterName. However, it didn't.", (String)"expected.cluster.Name", (String)embeddedCacheManager.getGlobalConfiguration().getClusterName());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseMachineIdPropIfExplicitlySet() throws Exception {
        String expectedMachineId = "expected.machine.Id";
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMachineId("expected.machine.Id");
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MachineId. However, it didn't.", (String)"expected.machine.Id", (String)embeddedCacheManager.getGlobalConfiguration().getMachineId());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseRackIdPropIfExplicitlySet() throws Exception {
        String expectedRackId = "expected.rack.Id";
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setRackId("expected.rack.Id");
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set RackId. However, it didn't.", (String)"expected.rack.Id", (String)embeddedCacheManager.getGlobalConfiguration().getRackId());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseSiteIdPropIfExplicitlySet() throws Exception {
        String expectedSiteId = "expected.site.Id";
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setSiteId("expected.site.Id");
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set SiteId. However, it didn't.", (String)"expected.site.Id", (String)embeddedCacheManager.getGlobalConfiguration().getSiteId());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseShutdownHookBehaviorPropIfExplicitlySet() throws Exception {
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setShutdownHookBehavior(GlobalConfiguration.ShutdownHookBehavior.DONT_REGISTER.name());
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ShutdownHookBehavior. However, it didn't.", (Object)GlobalConfiguration.ShutdownHookBehavior.DONT_REGISTER, (Object)embeddedCacheManager.getGlobalConfiguration().getShutdownHookBehavior());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseAsyncListenerExecutorPropertiesPropIfExplicitlySet() throws Exception {
        Properties expectedAsyncListenerExecutorProperties = new Properties();
        expectedAsyncListenerExecutorProperties.setProperty("key", "value");
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAsyncListenerExecutorProperties(expectedAsyncListenerExecutorProperties);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AsyncListenerExecutorProperties. However, it didn't.", (Object)expectedAsyncListenerExecutorProperties, (Object)embeddedCacheManager.getGlobalConfiguration().getAsyncListenerExecutorProperties());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseAsyncTransportExecutorPropertiesPropIfExplicitlySet() throws Exception {
        Properties expectedAsyncTransportExecutorProperties = new Properties();
        expectedAsyncTransportExecutorProperties.setProperty("key", "value");
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setAsyncTransportExecutorProperties(expectedAsyncTransportExecutorProperties);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set AsyncTransportExecutorProperties. However, it didn't.", (Object)expectedAsyncTransportExecutorProperties, (Object)embeddedCacheManager.getGlobalConfiguration().getAsyncTransportExecutorProperties());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseEvictionScheduledExecutorPropertiesPropIfExplicitlySet() throws Exception {
        Properties expectedEvictionScheduledExecutorProperties = new Properties();
        expectedEvictionScheduledExecutorProperties.setProperty("key", "value");
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setEvictionScheduledExecutorProperties(expectedEvictionScheduledExecutorProperties);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set EvictionScheduledExecutorProperties. However, it didn't.", (Object)expectedEvictionScheduledExecutorProperties, (Object)embeddedCacheManager.getGlobalConfiguration().getEvictionScheduledExecutorProperties());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseReplicationQueueScheduledExecutorPropertiesPropIfExplicitlySet() throws Exception {
        Properties expectedReplicationQueueScheduledExecutorProperties = new Properties();
        expectedReplicationQueueScheduledExecutorProperties.setProperty("key", "value");
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setReplicationQueueScheduledExecutorProperties(expectedReplicationQueueScheduledExecutorProperties);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set ReplicationQueueScheduledExecutorProperties. However, it didn't.", (Object)expectedReplicationQueueScheduledExecutorProperties, (Object)embeddedCacheManager.getGlobalConfiguration().getReplicationQueueScheduledExecutorProperties());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseMarshallVersionPropIfExplicitlySet() throws Exception {
        int setMarshallVersion = 1234;
        short expectedMarshallVersion = Version.getVersionShort((String)Version.decodeVersionForSerialization((short)1234));
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setMarshallVersion((short)1234);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set MarshallVersion. However, it didn't.", (short)expectedMarshallVersion, (short)embeddedCacheManager.getGlobalConfiguration().getMarshallVersion());
        embeddedCacheManager.stop();
    }

    @Test
    public final void infinispanEmbeddedCacheManagerFactoryBeanShouldUseDistributedSyncTimeoutPropIfExplicitlySet() throws Exception {
        long expectedDistributedSyncTimeout = 123456L;
        InfinispanEmbeddedCacheManagerFactoryBean objectUnderTest = new InfinispanEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setDistributedSyncTimeout(123456L);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager embeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should have used explicitly set DistributedSyncTimeout. However, it didn't.", (long)123456L, (long)embeddedCacheManager.getGlobalConfiguration().getDistributedSyncTimeout());
        embeddedCacheManager.stop();
    }
}

