/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support.embedded;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.AbstractEmbeddedCacheManagerFactory;
import org.infinispan.spring.support.embedded.InfinispanEmbeddedCacheManagerFactoryBean;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
@ContextConfiguration(value={"classpath:/org/infinispan/spring/support/embedded/InfinispanNamedEmbeddedCacheFactoryBeanContextTest.xml"})
@Test(testName="spring.support.embedded.InfinispanNamedEmbeddedCacheFactoryBeanContextTest", groups={"unit"})
public class InfinispanNamedEmbeddedCacheFactoryBeanContextTest
extends AbstractTestNGSpringContextTests {
    private static final String INFINISPAN_NAMED_EMBEDDED_CACHE_WITHOUT_FURTHER_CONFIGURATION_BEAN_NAME = "infinispanNamedEmbeddedCacheWithoutFurtherConfiguration";
    private static final String INFINISPAN_NAMED_EMBEDDED_CACHE_CONFIGURED_USING_MODE_NONE_BEAN_NAME = "infinispanNamedEmbeddedCacheConfiguredUsingModeNONE";
    private static final String INFINISPAN_NAMED_EMBEDDED_CACHE_CONFIGURED_USING_MODE_DEFAULT_BEAN_NAME = "infinispanNamedEmbeddedCacheConfiguredUsingModeDEFAULT";
    private static final String INFINISPAN_NAMED_EMBEDDED_CACHE_CONFIGURED_USING_MODE_NAMED_BEAN_NAME = "infinispanNamedEmbeddedCacheConfiguredUsingModeNAMED";

    @Test
    public final void shouldCreateAnEmbeddedCacheWithDefaultSettingsIfNoFurtherConfigurationGiven() {
        Cache infinispanNamedEmbeddedCacheWithoutFurtherConfiguration = (Cache)this.applicationContext.getBean(INFINISPAN_NAMED_EMBEDDED_CACHE_WITHOUT_FURTHER_CONFIGURATION_BEAN_NAME, Cache.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a named Infinispan cache having bean name = \"infinispanNamedEmbeddedCacheWithoutFurtherConfiguration\". However, it doesn't.", (Object)infinispanNamedEmbeddedCacheWithoutFurtherConfiguration);
    }

    @Test
    public final void shouldCreateAnEmbeddedCacheConfiguredUsingConfigurationModeNONE() {
        Cache infinispanNamedEmbeddedCacheConfiguredUsingConfigurationModeNone = (Cache)this.applicationContext.getBean(INFINISPAN_NAMED_EMBEDDED_CACHE_CONFIGURED_USING_MODE_NONE_BEAN_NAME, Cache.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a named Infinispan cache having bean name = \"infinispanNamedEmbeddedCacheConfiguredUsingModeNONE\" that has been configured using configuration mode NONE. However, it doesn't.", (Object)infinispanNamedEmbeddedCacheConfiguredUsingConfigurationModeNone);
    }

    @Test
    public final void shouldCreateAnEmbeddedCacheConfiguredUsingConfigurationModeDEFAULT() {
        Cache infinispanNamedEmbeddedCacheConfiguredUsingConfigurationModeDefault = (Cache)this.applicationContext.getBean(INFINISPAN_NAMED_EMBEDDED_CACHE_CONFIGURED_USING_MODE_DEFAULT_BEAN_NAME, Cache.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a named Infinispan cache having bean name = \"infinispanNamedEmbeddedCacheConfiguredUsingModeDEFAULT\" that has been configured using configuration mode DEFAULT. However, it doesn't.", (Object)infinispanNamedEmbeddedCacheConfiguredUsingConfigurationModeDefault);
    }

    @Test
    public final void shouldCreateAnEmbeddedCacheConfiguredUsingConfigurationModeNAMED() {
        Cache infinispanNamedEmbeddedCacheConfiguredUsingConfigurationModeNamed = (Cache)this.applicationContext.getBean(INFINISPAN_NAMED_EMBEDDED_CACHE_CONFIGURED_USING_MODE_NAMED_BEAN_NAME, Cache.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain a named Infinispan cache having bean name = \"infinispanNamedEmbeddedCacheConfiguredUsingModeNAMED\" that has been configured using configuration mode NAMED. However, it doesn't.", (Object)infinispanNamedEmbeddedCacheConfiguredUsingConfigurationModeNamed);
    }

    public static class TestInfinispanEmbeddedCacheManagerFactoryBean
    extends InfinispanEmbeddedCacheManagerFactoryBean {
        protected EmbeddedCacheManager createCacheManager(AbstractEmbeddedCacheManagerFactory.ConfigurationContainer template) {
            return TestCacheManagerFactory.createCacheManager((GlobalConfiguration)template.globalConfiguration, (Configuration)template.defaultConfiguration);
        }
    }
}

