/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class InfinispanNamespaceUtils {
    public static BeanComponentDefinition parseInnerBeanDefinition(Element element, ParserContext parserContext) {
        List childElements = DomUtils.getChildElementsByTagName((Element)element, (String)"bean");
        BeanComponentDefinition innerComponentDefinition = null;
        if (childElements != null && childElements.size() == 1) {
            Element beanElement = (Element)childElements.get(0);
            if (!"http://www.springframework.org/schema/beans".equals(beanElement.getNamespaceURI())) {
                throw new IllegalStateException("Illegal inner child element");
            }
            BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
            BeanDefinitionHolder beanDefinitionHolder = delegate.parseBeanDefinitionElement(beanElement);
            beanDefinitionHolder = delegate.decorateBeanDefinitionIfRequired(beanElement, beanDefinitionHolder);
            BeanDefinition beanDefinition = beanDefinitionHolder.getBeanDefinition();
            innerComponentDefinition = new BeanComponentDefinition(beanDefinition, beanDefinitionHolder.getBeanName());
        }
        return innerComponentDefinition;
    }

    public static void setPropertyIfAttributePresent(BeanDefinitionBuilder builder, Element element, String attributeName) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            builder.addPropertyValue(Conventions.attributeNameToPropertyName((String)attributeName), (Object)new TypedStringValue(attributeValue));
        }
    }
}

