/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.provider.SpringEmbeddedCacheManager;
import org.infinispan.spring.provider.SpringEmbeddedCacheManagerFactoryBean;
import org.infinispan.transaction.TransactionMode;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SpringEmbeddedCacheManagerFactoryBeanTest", groups={"unit"})
public class SpringEmbeddedCacheManagerFactoryBeanTest {
    private static final String CACHE_NAME_FROM_CONFIGURATION_FILE = "asyncCache";
    private static final String NAMED_ASYNC_CACHE_CONFIG_LOCATION = "named-async-cache.xml";

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldCreateACacheManagerEvenIfNoDefaultConfigurationLocationHasBeenSet() throws Exception {
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertNotNull((String)"getObject() should have returned a valid SpringEmbeddedCacheManager, even if no defaulConfigurationLocation has been specified. However, it returned null.", (Object)springEmbeddedCacheManager);
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldCreateACustomizedCacheManagerIfGivenADefaultConfigurationLocation() throws Exception {
        ClassPathResource infinispanConfig = new ClassPathResource(NAMED_ASYNC_CACHE_CONFIG_LOCATION, this.getClass());
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.setConfigurationFileLocation((Resource)infinispanConfig);
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertNotNull((String)"getObject() should have returned a valid SpringEmbeddedCacheManager, configured using the configuration file set on SpringEmbeddedCacheManagerFactoryBean. However, it returned null.", (Object)springEmbeddedCacheManager);
        SpringCache cacheDefinedInCustomConfiguration = springEmbeddedCacheManager.getCache(CACHE_NAME_FROM_CONFIGURATION_FILE);
        Configuration configuration = ((Cache)cacheDefinedInCustomConfiguration.getNativeCache()).getCacheConfiguration();
        AssertJUnit.assertEquals((String)"The cache named [asyncCache] is configured to have asynchonous replication cache mode. Yet, the cache returned from getCache(asyncCache) has a different cache mode. Obviously, SpringEmbeddedCacheManagerFactoryBean did not use the configuration file when instantiating SpringEmbeddedCacheManager.", (Object)CacheMode.REPL_ASYNC, (Object)configuration.clustering().cacheMode());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldReportTheCorrectObjectType() throws Exception {
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"getObjectType() should return the most derived class of the actual SpringEmbeddedCacheManager implementation returned from getObject(). However, it didn't.", springEmbeddedCacheManager.getClass(), (Object)objectUnderTest.getObjectType());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldDeclareItselfToOnlyProduceSingletons() {
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        AssertJUnit.assertTrue((String)"isSingleton() should always return true. However, it returned false", (boolean)objectUnderTest.isSingleton());
    }

    @Test
    public final void springEmbeddedCacheManagerFactoryBeanShouldStopTheCreateEmbeddedCacheManagerWhenBeingDestroyed() throws Exception {
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        SpringEmbeddedCacheManager springEmbeddedCacheManager = objectUnderTest.getObject();
        springEmbeddedCacheManager.getCache("default");
        objectUnderTest.destroy();
        AssertJUnit.assertEquals((String)"SpringEmbeddedCacheManagerFactoryBean should stop the created SpringEmbeddedCacheManager when being destroyed. However, the created SpringEmbeddedCacheManager is still not terminated.", (Object)ComponentStatus.TERMINATED, (Object)springEmbeddedCacheManager.getNativeCacheManager().getStatus());
        springEmbeddedCacheManager.stop();
    }

    @Test
    public final void testAddConfigurations() throws Exception {
        SpringEmbeddedCacheManagerFactoryBean objectUnderTest = new SpringEmbeddedCacheManagerFactoryBean();
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        gcb.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true));
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        objectUnderTest.addCustomGlobalConfiguration(gcb);
        objectUnderTest.addCustomCacheConfiguration(builder);
        objectUnderTest.afterPropertiesSet();
        EmbeddedCacheManager infinispanEmbeddedCacheManager = objectUnderTest.getObject().getNativeCacheManager();
        AssertJUnit.assertEquals((boolean)infinispanEmbeddedCacheManager.getCacheManagerConfiguration().globalJmxStatistics().allowDuplicateDomains(), (boolean)gcb.build().globalJmxStatistics().allowDuplicateDomains());
        AssertJUnit.assertEquals((boolean)infinispanEmbeddedCacheManager.getDefaultCacheConfiguration().transaction().transactionMode().isTransactional(), (boolean)builder.build().transaction().transactionMode().isTransactional());
    }
}

