/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.spring.AssertionUtils;
import org.infinispan.spring.mock.MockExecutorFatory;
import org.infinispan.spring.mock.MockMarshaller;
import org.infinispan.spring.mock.MockRequestBalancingStrategy;
import org.infinispan.spring.mock.MockTransportFactory;
import org.infinispan.spring.provider.SpringRemoteCacheManager;
import org.infinispan.spring.provider.SpringRemoteCacheManagerFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="spring.provider.SpringRemoteCacheManagerFactoryBeanTest", groups={"unit"})
public class SpringRemoteCacheManagerFactoryBeanTest {
    private static final Resource HOTROD_CLIENT_PROPERTIES_LOCATION = new ClassPathResource("hotrod-client.properties", SpringRemoteCacheManagerFactoryBeanTest.class);

    @Test(expectedExceptions={IllegalStateException.class})
    public final void shouldThrowAnIllegalStateExceptionIfBothConfigurationPropertiesAndConfifurationPropertiesFileLocationAreSet() throws Exception {
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setConfigurationProperties(new Properties());
        objectUnderTest.setConfigurationPropertiesFileLocation((Resource)new ClassPathResource("dummy", this.getClass()));
        objectUnderTest.afterPropertiesSet();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public final void shouldThrowAnIllegalStateExceptionIfConfigurationPropertiesAsWellAsSettersAreUsedToConfigureTheRemoteCacheManager() throws Exception {
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setConfigurationProperties(new Properties());
        objectUnderTest.setTransportFactory("test.TransportFactory");
        objectUnderTest.afterPropertiesSet();
    }

    @Test
    public final void infinispanRemoteCacheFactoryBeanShouldReportTheMostDerivedObjectType() throws Exception {
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        AssertJUnit.assertEquals((String)"getObjectType() should have returned the most derived class of the actual RemoteCache implementation returned from getObject(). However, it didn't.", objectUnderTest.getObject().getClass(), (Object)objectUnderTest.getObjectType());
        objectUnderTest.destroy();
    }

    @Test
    public final void shouldProduceARemoteCacheManagerConfiguredUsingDefaultSettingsIfNeitherConfigurationPropertiesNorConfigurationPropertiesFileLocationHasBeenSet() throws Exception {
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertionUtils.assertPropertiesSubset("The configuration properties used by the SpringRemoteCacheManager returned von getObject() should be equal to SpringRemoteCacheManager's default settings since neither property 'configurationProperties' nor property 'configurationPropertiesFileLocation' has been set. However, those two are not equal.", new RemoteCacheManager().getProperties(), remoteCacheManager.getNativeCacheManager().getProperties());
        objectUnderTest.destroy();
    }

    @Test
    public final void isSingletonShouldAlwaysReturnTrue() {
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        AssertJUnit.assertTrue((String)"isSingleton() should always return true since each SpringRemoteCacheManagerFactoryBean will always produce the same SpringRemoteCacheManager instance. However,it returned false.", (boolean)objectUnderTest.isSingleton());
    }

    @Test
    public final void destroyShouldStopTheProducedCache() throws Exception {
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        objectUnderTest.destroy();
        AssertJUnit.assertFalse((String)"destroy() should have stopped the SpringRemoteCacheManager instance previously produced by SpringRemoteCacheManagerFactoryBean. However, the produced SpringRemoteCacheManager is still running. ", (boolean)remoteCacheManager.getNativeCacheManager().isStarted());
    }

    @Test
    public final void shouldProduceACacheConfiguredUsingTheSuppliedConfigurationProperties() throws Exception {
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        Properties configurationProperties = this.loadConfigurationProperties(HOTROD_CLIENT_PROPERTIES_LOCATION);
        objectUnderTest.setConfigurationProperties(configurationProperties);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertionUtils.assertPropertiesSubset("The configuration properties used by the SpringRemoteCacheManager returned von getObject() should be equal to those passed into SpringRemoteCacheManagerFactoryBean via setConfigurationProperties(props). However, those two are not equal.", configurationProperties, remoteCacheManager.getNativeCacheManager().getProperties());
        objectUnderTest.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadConfigurationProperties(Resource configurationPropertiesLocation) throws IOException {
        try (InputStream propsStream = null;){
            propsStream = HOTROD_CLIENT_PROPERTIES_LOCATION.getInputStream();
            Properties configurationProperties = new Properties();
            configurationProperties.load(propsStream);
            Properties properties = configurationProperties;
            return properties;
        }
    }

    @Test
    public final void shouldProduceACacheConfiguredUsingPropertiesLoadedFromALocationDeclaredThroughSetConfigurationPropertiesFileLocation() throws Exception {
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setConfigurationPropertiesFileLocation(HOTROD_CLIENT_PROPERTIES_LOCATION);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertionUtils.assertPropertiesSubset("The configuration properties used by the SpringRemoteCacheManager returned von getObject() should be equal to those passed into SpringRemoteCacheManagerFactoryBean via setConfigurationPropertiesFileLocation(propsFileLocation). However, those two are not equal.", this.loadConfigurationProperties(HOTROD_CLIENT_PROPERTIES_LOCATION), remoteCacheManager.getNativeCacheManager().getProperties());
        objectUnderTest.destroy();
    }

    @Test
    public final void shouldProduceAStoppedCacheIfStartAutomaticallyIsSetToFalse() throws Exception {
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setStartAutomatically(false);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManagerExpectedToBeInStateStopped = objectUnderTest.getObject();
        AssertJUnit.assertFalse((String)"SpringRemoteCacheManagerFactoryBean should have produced a SpringRemoteCacheManager that is initially in state stopped since property 'startAutomatically' has been set to false. However, the produced SpringRemoteCacheManager is already started.", (boolean)remoteCacheManagerExpectedToBeInStateStopped.getNativeCacheManager().isStarted());
        objectUnderTest.destroy();
    }

    @Test
    public final void setTransportFactoryShouldOverrideDefaultTransportFactory() throws Exception {
        String expectedTransportFactory = MockTransportFactory.class.getName();
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setTransportFactory(expectedTransportFactory);
        objectUnderTest.setStartAutomatically(false);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setTransportFactory(" + expectedTransportFactory + ") should have overridden property 'transportFactory'. However, it didn't."), (Object)expectedTransportFactory, (Object)remoteCacheManager.getNativeCacheManager().getProperties().get("infinispan.client.hotrod.transport_factory"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setServerListShouldOverrideDefaultServerList() throws Exception {
        ArrayList<InetSocketAddress> expectedServerList = new ArrayList<InetSocketAddress>(1);
        expectedServerList.add(new InetSocketAddress("testhost", 4632));
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        String expectedServerListString = "testhost:4632";
        objectUnderTest.setServerList(expectedServerList);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setServerList(" + expectedServerList + ") should have overridden property 'serverList'. However, it didn't."), (Object)"testhost:4632", (Object)remoteCacheManager.getNativeCacheManager().getProperties().get("infinispan.client.hotrod.server_list"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setMarshallerShouldOverrideDefaultMarshaller() throws Exception {
        String expectedMarshaller = MockMarshaller.class.getName();
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setMarshaller(expectedMarshaller);
        objectUnderTest.setStartAutomatically(false);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setMarshaller(" + expectedMarshaller + ") should have overridden property 'marshaller'. However, it didn't."), (Object)expectedMarshaller, (Object)remoteCacheManager.getNativeCacheManager().getProperties().get("infinispan.client.hotrod.marshaller"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setAsyncExecutorFactoryShouldOverrideDefaultAsyncExecutorFactory() throws Exception {
        String expectedAsyncExecutorFactory = MockExecutorFatory.class.getName();
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setAsyncExecutorFactory(expectedAsyncExecutorFactory);
        objectUnderTest.setStartAutomatically(false);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setAsyncExecutorFactory(" + expectedAsyncExecutorFactory + ") should have overridden property 'asyncExecutorFactory'. However, it didn't."), (Object)expectedAsyncExecutorFactory, (Object)remoteCacheManager.getNativeCacheManager().getProperties().get("infinispan.client.hotrod.async_executor_factory"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setTcpNoDelayShouldOverrideDefaultTcpNoDelay() throws Exception {
        boolean expectedTcpNoDelay = true;
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setTcpNoDelay(true);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setTcpNoDelay(true) should have overridden property 'tcpNoDelay'. However, it didn't.", (Object)String.valueOf(true), (Object)remoteCacheManager.getNativeCacheManager().getProperties().get("infinispan.client.hotrod.tcp_no_delay"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setTcpKeepAliveOverrideDefaultTcpKeepAlive() throws Exception {
        boolean expectedTcpKeepAlive = false;
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setTcpKeepAlive(false);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setTcpKeepAlive(false) should have overridden property 'tcpKeepAlive'. However, it didn't.", (Object)String.valueOf(false), (Object)remoteCacheManager.getNativeCacheManager().getProperties().get("infinispan.client.hotrod.tcp_keep_alive"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setPingOnStartupShouldOverrideDefaultPingOnStartup() throws Exception {
        boolean expectedPingOnStartup = true;
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setPingOnStartup(true);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setPingOnStartup(true) should have overridden property 'transportFactory'. However, it didn't.", (Object)String.valueOf(true), (Object)remoteCacheManager.getNativeCacheManager().getProperties().get("infinispan.client.hotrod.ping_on_startup"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setRequestBalancingStrategyShouldOverrideDefaultRequestBalancingStrategy() throws Exception {
        String expectedRequestBalancingStrategy = MockRequestBalancingStrategy.class.getName();
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setRequestBalancingStrategy(expectedRequestBalancingStrategy);
        objectUnderTest.setStartAutomatically(false);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)("setRequestBalancingStrategy(" + expectedRequestBalancingStrategy + ") should have overridden property 'requestBalancingStrategy'. However, it didn't."), (Object)expectedRequestBalancingStrategy, (Object)remoteCacheManager.getNativeCacheManager().getProperties().get("infinispan.client.hotrod.request_balancing_strategy"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setKeySizeEstimateShouldOverrideDefaultKeySizeEstimate() throws Exception {
        int expectedKeySizeEstimate = -123456;
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setKeySizeEstimate(-123456);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setKeySizeEstimate(-123456) should have overridden property 'keySizeEstimate'. However, it didn't.", (Object)String.valueOf(-123456), (Object)remoteCacheManager.getNativeCacheManager().getProperties().get("infinispan.client.hotrod.key_size_estimate"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setValueSizeEstimateShouldOverrideDefaultValueSizeEstimate() throws Exception {
        int expectedValueSizeEstimate = -3456789;
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setValueSizeEstimate(-3456789);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setValueSizeEstimate(-3456789) should have overridden property 'valueSizeEstimate'. However, it didn't.", (Object)String.valueOf(-3456789), (Object)remoteCacheManager.getNativeCacheManager().getProperties().get("infinispan.client.hotrod.value_size_estimate"));
        objectUnderTest.destroy();
    }

    @Test
    public final void setForceReturnValuesShouldOverrideDefaultForceReturnValues() throws Exception {
        boolean expectedForceReturnValues = true;
        SpringRemoteCacheManagerFactoryBean objectUnderTest = new SpringRemoteCacheManagerFactoryBean();
        objectUnderTest.setForceReturnValues(true);
        objectUnderTest.afterPropertiesSet();
        SpringRemoteCacheManager remoteCacheManager = objectUnderTest.getObject();
        AssertJUnit.assertEquals((String)"setForceReturnValue(true) should have overridden property 'forceReturnValue'. However, it didn't.", (Object)String.valueOf(true), (Object)remoteCacheManager.getNativeCacheManager().getProperties().get("infinispan.client.hotrod.force_return_values"));
        objectUnderTest.destroy();
    }
}

