/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.spring.provider.NullValue;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

public class SpringRemoteCache
implements Cache {
    private final RemoteCache<Object, Object> nativeCache;

    public SpringRemoteCache(RemoteCache<Object, Object> nativeCache) {
        Assert.notNull(nativeCache, (String)"A non-null Infinispan cache implementation is required");
        this.nativeCache = nativeCache;
    }

    public String getName() {
        return this.nativeCache.getName();
    }

    public RemoteCache<?, ?> getNativeCache() {
        return this.nativeCache;
    }

    public Cache.ValueWrapper get(Object key) {
        Object v = this.nativeCache.get(key);
        if (v == null) {
            return null;
        }
        if (v == NullValue.NULL) {
            return NullValue.NULL;
        }
        return new SimpleValueWrapper(v);
    }

    public void put(Object key, Object value) {
        this.nativeCache.put(key, value != null ? value : NullValue.NULL);
    }

    public void evict(Object key) {
        this.nativeCache.remove(key);
    }

    public void clear() {
        this.nativeCache.clear();
    }

    public String toString() {
        return "InfinispanCache [nativeCache = " + this.nativeCache + "]";
    }
}

