/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Properties;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.spring.ConfigurationPropertiesOverrides;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="spring.ConfigurationPropertiesOverridesTest")
public class ConfigurationPropertiesOverridesTest {
    private final Properties defaultConfigurationProperties = new ConfigurationProperties().getProperties();

    @Test
    public final void testIfIsEmptyRecognizesThatConfigurationPropertiesOverridesAreEmpty() {
        ConfigurationPropertiesOverrides objectUnderTest = new ConfigurationPropertiesOverrides();
        AssertJUnit.assertTrue((String)"isEmpty() should have noticed that the ConfigurationPropertiesOverrides instance is indeed empty. However, it didn't.", (boolean)objectUnderTest.isEmpty());
    }

    @Test
    public final void testIfIsEmptyShouldRecognizesThatConfigurationPropertiesOverridesAreNotEmpty() {
        ConfigurationPropertiesOverrides objectUnderTest = new ConfigurationPropertiesOverrides();
        objectUnderTest.setTransportFactory("test.TransportFactory");
        AssertJUnit.assertFalse((String)"isEmpty() should have noticed that the ConfigurationPropertiesOverrides instance is not empty. However, it didn't.", (boolean)objectUnderTest.isEmpty());
    }

    @Test
    public final void testIfSetTransportFactoryOverridesDefaultTransportFactory() {
        String expectedTransportFactory = "test.TransportFactory";
        ConfigurationPropertiesOverrides objectUnderTest = new ConfigurationPropertiesOverrides();
        objectUnderTest.setTransportFactory("test.TransportFactory");
        Properties overriddenConfigurationProperties = objectUnderTest.override(this.defaultConfigurationProperties);
        AssertJUnit.assertEquals((String)("override(" + this.defaultConfigurationProperties + ") should have overridden property 'transportFactory'. However, it didn't."), (String)"test.TransportFactory", (String)overriddenConfigurationProperties.getProperty("infinispan.client.hotrod.transport_factory"));
    }

    @Test
    public final void testIfSetMarshallerOverridesDefaultMarshaller() {
        String expectedMarshaller = "test.Marshaller";
        ConfigurationPropertiesOverrides objectUnderTest = new ConfigurationPropertiesOverrides();
        objectUnderTest.setMarshaller("test.Marshaller");
        Properties overriddenConfigurationProperties = objectUnderTest.override(this.defaultConfigurationProperties);
        AssertJUnit.assertEquals((String)("override(" + this.defaultConfigurationProperties + ") should have overridden property 'transportFactory'. However, it didn't."), (String)"test.Marshaller", (String)overriddenConfigurationProperties.getProperty("infinispan.client.hotrod.marshaller"));
    }

    @Test
    public final void testIfSetServerListOverridesDefaultServerList() {
        ArrayList<InetSocketAddress> expectedServerList = new ArrayList<InetSocketAddress>(1);
        expectedServerList.add(new InetSocketAddress("testhost", 4632));
        ConfigurationPropertiesOverrides objectUnderTest = new ConfigurationPropertiesOverrides();
        String expectedServerListString = "testhost:4632";
        objectUnderTest.setServerList(expectedServerList);
        Properties overriddenConfigurationProperties = objectUnderTest.override(this.defaultConfigurationProperties);
        AssertJUnit.assertEquals((String)("override(" + this.defaultConfigurationProperties + ") should have overridden property 'transportFactory'. However, it didn't."), (String)"testhost:4632", (String)overriddenConfigurationProperties.getProperty("infinispan.client.hotrod.server_list"));
    }

    @Test
    public final void testIfSetAsyncExecutorFactoryOverridesDefaultAsyncExecutorFactory() {
        String expectedAsyncExecutorFactory = "test.AsyncExecutorFactor";
        ConfigurationPropertiesOverrides objectUnderTest = new ConfigurationPropertiesOverrides();
        objectUnderTest.setAsyncExecutorFactory("test.AsyncExecutorFactor");
        Properties overriddenConfigurationProperties = objectUnderTest.override(this.defaultConfigurationProperties);
        AssertJUnit.assertEquals((String)("override(" + this.defaultConfigurationProperties + ") should have overridden property 'transportFactory'. However, it didn't."), (String)"test.AsyncExecutorFactor", (String)overriddenConfigurationProperties.getProperty("infinispan.client.hotrod.async_executor_factory"));
    }

    @Test
    public final void testIfSetTcpNoDelayOverridesDefaultTcpNoDelay() {
        boolean expectedTcpNoDelay = true;
        ConfigurationPropertiesOverrides objectUnderTest = new ConfigurationPropertiesOverrides();
        objectUnderTest.setTcpNoDelay(true);
        Properties overriddenConfigurationProperties = objectUnderTest.override(this.defaultConfigurationProperties);
        AssertJUnit.assertEquals((String)("override(" + this.defaultConfigurationProperties + ") should have overridden property 'transportFactory'. However, it didn't."), (String)String.valueOf(true), (String)overriddenConfigurationProperties.getProperty("infinispan.client.hotrod.tcp_no_delay"));
    }

    @Test
    public final void testIfSetTcpKeepAliveOverridesDefaultTcpKeepAive() {
        boolean expectedTcpKeepAlive = false;
        ConfigurationPropertiesOverrides objectUnderTest = new ConfigurationPropertiesOverrides();
        objectUnderTest.setTcpKeepAlive(false);
        Properties overriddenConfigurationProperties = objectUnderTest.override(this.defaultConfigurationProperties);
        AssertJUnit.assertEquals((String)("override(" + this.defaultConfigurationProperties + ") should have overridden property 'transportFactory'. However, it didn't."), (String)String.valueOf(false), (String)overriddenConfigurationProperties.getProperty("infinispan.client.hotrod.tcp_keep_alive"));
    }

    @Test
    public final void testIfSetRequestBalancingStrategyOverridesDefaultRequestBalancingStrategy() {
        String expectedRequestBalancingStrategy = "test.RequestBalancingStrategy";
        ConfigurationPropertiesOverrides objectUnderTest = new ConfigurationPropertiesOverrides();
        objectUnderTest.setRequestBalancingStrategy("test.RequestBalancingStrategy");
        Properties overriddenConfigurationProperties = objectUnderTest.override(this.defaultConfigurationProperties);
        AssertJUnit.assertEquals((String)("override(" + this.defaultConfigurationProperties + ") should have overridden property 'transportFactory'. However, it didn't."), (String)"test.RequestBalancingStrategy", (String)overriddenConfigurationProperties.getProperty("infinispan.client.hotrod.request_balancing_strategy"));
    }

    @Test
    public final void testIfSetKeySizeEstimateOverridesDefaultKeySizeEstimate() {
        int expectedKeySizeEstimate = -123456;
        ConfigurationPropertiesOverrides objectUnderTest = new ConfigurationPropertiesOverrides();
        objectUnderTest.setKeySizeEstimate(-123456);
        Properties overriddenConfigurationProperties = objectUnderTest.override(this.defaultConfigurationProperties);
        AssertJUnit.assertEquals((String)("override(" + this.defaultConfigurationProperties + ") should have overridden property 'transportFactory'. However, it didn't."), (String)String.valueOf(-123456), (String)overriddenConfigurationProperties.getProperty("infinispan.client.hotrod.key_size_estimate"));
    }

    @Test
    public final void testIfValueSizeEstimateOverridesDefaultValueSizeEstimate() {
        int expectedValueSizeEstimate = -3456789;
        ConfigurationPropertiesOverrides objectUnderTest = new ConfigurationPropertiesOverrides();
        objectUnderTest.setValueSizeEstimate(-3456789);
        Properties overriddenConfigurationProperties = objectUnderTest.override(this.defaultConfigurationProperties);
        AssertJUnit.assertEquals((String)("override(" + this.defaultConfigurationProperties + ") should have overridden property 'transportFactory'. However, it didn't."), (String)String.valueOf(-3456789), (String)overriddenConfigurationProperties.getProperty("infinispan.client.hotrod.value_size_estimate"));
    }

    @Test
    public final void testIfForceReturnValuesOverridesDefaultForceReturnValues() {
        boolean expectedForceReturnValues = true;
        ConfigurationPropertiesOverrides objectUnderTest = new ConfigurationPropertiesOverrides();
        objectUnderTest.setForceReturnValues(true);
        Properties overriddenConfigurationProperties = objectUnderTest.override(this.defaultConfigurationProperties);
        AssertJUnit.assertEquals((String)("override(" + this.defaultConfigurationProperties + ") should have overridden property 'transportFactory'. However, it didn't."), (String)String.valueOf(true), (String)overriddenConfigurationProperties.getProperty("infinispan.client.hotrod.force_return_values"));
    }
}

