/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.session;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.spring.provider.SpringCache;
import org.infinispan.spring.session.AbstractApplicationPublisherBridge;
import org.infinispan.spring.session.PrincipalNameResolver;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;

public abstract class AbstractInfinispanSessionRepository
implements SessionRepository<MapSession>,
FindByIndexNameSessionRepository<MapSession>,
ApplicationEventPublisherAware,
InitializingBean,
DisposableBean {
    protected final AbstractApplicationPublisherBridge applicationEventPublisher;
    protected final SpringCache cache;
    protected final PrincipalNameResolver principalNameResolver = new PrincipalNameResolver();

    protected AbstractInfinispanSessionRepository(SpringCache cache, AbstractApplicationPublisherBridge eventsBridge) {
        Objects.requireNonNull(cache, "SpringCache can not be null");
        Objects.requireNonNull(eventsBridge, "EventBridge can not be null");
        this.applicationEventPublisher = eventsBridge;
        this.cache = cache;
    }

    public void afterPropertiesSet() throws Exception {
        this.applicationEventPublisher.registerListener();
    }

    public void destroy() throws Exception {
        this.applicationEventPublisher.unregisterListener();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher.setApplicationEventPublisher(applicationEventPublisher);
    }

    public MapSession createSession() {
        MapSession result = new MapSession();
        result.setCreationTime(System.currentTimeMillis());
        return result;
    }

    public void save(MapSession session) {
        this.cache.put(session.getId(), session, session.getMaxInactiveIntervalInSeconds(), TimeUnit.SECONDS);
    }

    public MapSession getSession(String id) {
        return this.getSession(id, true);
    }

    public MapSession getSession(String id, boolean updateTTL) {
        return Optional.ofNullable(this.cache.get(id)).map(v -> (MapSession)v.get()).map(v -> this.updateTTL((MapSession)v, updateTTL)).orElse(null);
    }

    protected MapSession updateTTL(MapSession session, boolean updateTTL) {
        if (updateTTL) {
            session.setLastAccessedTime(System.currentTimeMillis());
            this.cache.put(session.getId(), session, session.getMaxInactiveIntervalInSeconds(), TimeUnit.SECONDS);
        }
        return session;
    }

    public void delete(String id) {
        this.applicationEventPublisher.emitSessionDeletedEvent(id);
        this.cache.evict(id);
    }

    public Map<String, MapSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        if (!PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Collections.emptyMap();
        }
        return this.cache.getNativeCache().values().stream().map(cacheValue -> (MapSession)cacheValue).filter(session -> indexValue.equals(this.principalNameResolver.resolvePrincipal((Session)session))).collect(Collectors.toMap(MapSession::getId, Function.identity()));
    }
}

