/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.provider.sample;

import java.util.Random;
import org.infinispan.spring.provider.sample.AbstractTestTemplate;
import org.infinispan.spring.provider.sample.entity.Book;
import org.infinispan.spring.provider.sample.service.CachedBookServiceJsr107;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.Test;

public abstract class AbstractTestTemplateJsr107
extends AbstractTestTemplate {
    @Autowired
    private CachedBookServiceJsr107 bookDao;

    @Test
    public void demonstrateCachingLoadedBooksJsr107() {
        Integer bookToCacheId = 5;
        assert (!this.booksCache().containsKey((Object)bookToCacheId)) : "Cache should not initially contain the book with id " + bookToCacheId;
        Book cachedBook = this.bookDao.findBook(bookToCacheId);
        log.infof("Book [%s] cached", (Object)cachedBook);
        assert (cachedBook.equals(this.booksCache().get((Object)bookToCacheId))) : "findBook(" + bookToCacheId + ") should have cached book";
    }

    @Test
    public void demonstrateRemovingBookFromCacheJsr107() {
        Integer bookToDeleteId = new Random().nextInt(10) + 1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "Cache should not initially contain the book with id " + bookToDeleteId;
        Book bookToDelete = this.bookDao.findBook(bookToDeleteId);
        log.infof("Book [%s] cached", (Object)bookToDelete);
        assert (this.booksCache().get((Object)bookToDeleteId).equals(bookToDelete)) : "findBook(" + bookToDeleteId + ") should have cached book";
        log.infof("Deleting book [%s] ...", (Object)bookToDelete);
        this.bookDao.deleteBook(bookToDeleteId);
        log.infof("Book [%s] deleted", (Object)bookToDelete);
        assert (!this.booksCache().containsKey((Object)bookToDeleteId)) : "deleteBook(" + bookToDelete + ") should have evicted book from cache.";
    }

    @Test
    public void demonstrateCacheEvictionUponUpdateJsr107() {
        Integer bookToUpdateId = 2;
        assert (!this.booksCache().containsKey((Object)bookToUpdateId)) : "Cache should not initially contain the book with id " + bookToUpdateId;
        Book bookToUpdate = new Book("112-358-132", "Random Author", "Path to Infinispan Enlightenment");
        this.booksCache().put((Object)bookToUpdate, (Object)bookToUpdate);
        assert (this.booksCache().containsKey((Object)bookToUpdate));
        bookToUpdate.setTitle("Work in Progress");
        Book result = this.bookDao.updateBook(bookToUpdate);
        log.infof("Book [%s] updated", (Object)bookToUpdate);
        assert (!this.booksCache().containsKey((Object)bookToUpdate)) : "updateBook(" + bookToUpdate + ") should have removed updated book from cache";
    }

    @Test
    public void demonstrateCachePutOnCreateJsr107() {
        Book bookToCreate = new Book("112-358-132", "Random Author", "Path to Infinispan Enlightenment");
        log.infof("Creating book [%s] ...", (Object)bookToCreate);
        Book result = this.bookDao.createBook(bookToCreate);
        log.infof("Book [%s] created", (Object)bookToCreate);
        assert (this.booksCache().get((Object)result).equals(bookToCreate)) : "createBook(" + bookToCreate + ") should have inserted created book into cache";
    }

    @Test
    public void testDeleteAllEntriesJsr107() {
        Integer bookToDeleteId1 = 5;
        Integer bookToDeleteId2 = 6;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId1)) : "Cache should not initially contain the book with id " + bookToDeleteId1;
        assert (!this.booksCache().containsKey((Object)bookToDeleteId2)) : "Cache should not initially contain the book with id " + bookToDeleteId2;
        Book bookToDelete1 = this.bookDao.findBook(bookToDeleteId1);
        log.infof("Book [%s] cached", (Object)bookToDelete1);
        assert (bookToDelete1.equals(this.booksCache().get((Object)bookToDeleteId1))) : "findBook(" + bookToDeleteId1 + ") should have cached book";
        Book bookToDelete2 = this.bookDao.findBook(bookToDeleteId2);
        log.infof("Book [%s] cached", (Object)bookToDelete2);
        assert (bookToDelete2.equals(this.booksCache().get((Object)bookToDeleteId2))) : "findBook(" + bookToDeleteId2 + ") should have cached book";
        log.infof("Deleting book [%s] ...", (Object)bookToDelete1);
        this.bookDao.deleteBookAllEntries(bookToDeleteId1);
        log.infof("Book [%s] deleted", (Object)bookToDelete1);
        assert (!this.booksCache().containsKey((Object)bookToDelete1.getId())) : "deleteBook(" + bookToDelete1 + ") should have evicted book from cache.";
        assert (!this.booksCache().containsKey((Object)bookToDelete2.getId())) : "deleteBook(" + bookToDelete2 + ") should have evicted book from cache.";
    }
}

